/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.PipelineDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.api.config.CreateTableConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.yaml.YamlPipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.api.metadata.ActualTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.SchemaName;
import org.apache.shardingsphere.data.pipeline.api.metadata.SchemaTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.TableName;
import org.apache.shardingsphere.data.pipeline.api.pojo.CreateMigrationJobParameter;
import org.apache.shardingsphere.data.pipeline.api.pojo.PipelineJobMetaData;
import org.apache.shardingsphere.data.pipeline.api.pojo.TableBasedPipelineJobInfo;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.api.impl.AbstractInventoryIncrementalJobAPIImpl;
import org.apache.shardingsphere.data.pipeline.core.api.impl.PipelineDataSourcePersistService;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalProcessContext;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceFactory;
import org.apache.shardingsphere.data.pipeline.core.exception.connection.AddMigrationSourceResourceException;
import org.apache.shardingsphere.data.pipeline.core.exception.connection.DropMigrationSourceResourceException;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineSchemaUtil;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataUtil;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.StandardPipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobItemContext;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJob;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobId;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationProcessContext;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.yaml.job.YamlMigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.yaml.job.YamlMigrationJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.yaml.metadata.YamlPipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.yaml.metadata.YamlPipelineColumnMetaDataSwapper;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationJobAPIImpl
extends AbstractInventoryIncrementalJobAPIImpl
implements MigrationJobAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationJobAPIImpl.class);
    private final YamlRuleConfigurationSwapperEngine swapperEngine = new YamlRuleConfigurationSwapperEngine();
    private final YamlDataSourceConfigurationSwapper swapper = new YamlDataSourceConfigurationSwapper();
    private final PipelineDataSourcePersistService dataSourcePersistService = new PipelineDataSourcePersistService();

    @Override
    protected String marshalJobIdLeftPart(PipelineJobId pipelineJobId) {
        MigrationJobId jobId = (MigrationJobId)pipelineJobId;
        String sourceSchemaName = null != jobId.getSourceSchemaName() ? jobId.getSourceSchemaName() : "";
        String text = Joiner.on((char)'|').join((Object)jobId.getSourceResourceName(), (Object)sourceSchemaName, new Object[]{jobId.getSourceTableName(), jobId.getTargetDatabaseName(), jobId.getTargetTableName()});
        return DigestUtils.md5Hex((byte[])text.getBytes(StandardCharsets.UTF_8));
    }

    protected TableBasedPipelineJobInfo getJobInfo(String jobId) {
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        PipelineJobMetaData jobMetaData = new PipelineJobMetaData(jobId, !jobConfigPOJO.isDisabled(), jobConfigPOJO.getShardingTotalCount(), jobConfigPOJO.getProps().getProperty("create_time"), jobConfigPOJO.getProps().getProperty("stop_time"), jobConfigPOJO.getJobParameter());
        return new TableBasedPipelineJobInfo(jobMetaData, this.getJobConfiguration(jobConfigPOJO).getSourceTableName());
    }

    @Override
    public void extendYamlJobConfiguration(YamlPipelineJobConfiguration yamlJobConfig) {
        YamlMigrationJobConfiguration config = (YamlMigrationJobConfiguration)yamlJobConfig;
        if (null == yamlJobConfig.getJobId()) {
            config.setJobId(this.generateJobId(config));
        }
        if (Strings.isNullOrEmpty((String)config.getSourceDatabaseType())) {
            PipelineDataSourceConfiguration sourceDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)config.getSource().getType(), (String)config.getSource().getParameter());
            config.setSourceDatabaseType(sourceDataSourceConfig.getDatabaseType().getType());
        }
        if (Strings.isNullOrEmpty((String)config.getTargetDatabaseType())) {
            PipelineDataSourceConfiguration targetDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)config.getTarget().getType(), (String)config.getTarget().getParameter());
            config.setTargetDatabaseType(targetDataSourceConfig.getDatabaseType().getType());
        }
        JobDataNodeEntry nodeEntry = new JobDataNodeEntry(config.getTargetTableName(), Collections.singleton(new DataNode(config.getSourceResourceName(), config.getSourceTableName())));
        String dataNodeLine = new JobDataNodeLine(Collections.singleton(nodeEntry)).marshal();
        config.setTablesFirstDataNodes(dataNodeLine);
        config.setJobShardingDataNodes(Collections.singletonList(dataNodeLine));
    }

    private String generateJobId(YamlMigrationJobConfiguration config) {
        MigrationJobId jobId = new MigrationJobId(config.getSourceResourceName(), config.getSourceSchemaName(), config.getSourceTableName(), config.getTargetDatabaseName(), config.getTargetTableName());
        return this.marshalJobId(jobId);
    }

    @Override
    protected YamlPipelineJobConfiguration swapToYamlJobConfiguration(PipelineJobConfiguration jobConfig) {
        return new YamlMigrationJobConfigurationSwapper().swapToYamlConfiguration((MigrationJobConfiguration)jobConfig);
    }

    @Override
    public MigrationJobConfiguration getJobConfiguration(String jobId) {
        return this.getJobConfiguration(this.getElasticJobConfigPOJO(jobId));
    }

    protected MigrationJobConfiguration getJobConfiguration(JobConfigurationPOJO jobConfigPOJO) {
        return new YamlMigrationJobConfigurationSwapper().swapToObject(jobConfigPOJO.getJobParameter());
    }

    @Override
    protected String getTargetDatabaseType(PipelineJobConfiguration pipelineJobConfig) {
        return ((MigrationJobConfiguration)pipelineJobConfig).getTargetDatabaseType();
    }

    @Override
    public MigrationTaskConfiguration buildTaskConfiguration(PipelineJobConfiguration pipelineJobConfig, int jobShardingItem, PipelineProcessConfiguration pipelineProcessConfig) {
        MigrationJobConfiguration jobConfig = (MigrationJobConfiguration)pipelineJobConfig;
        LinkedHashMap<ActualTableName, LogicTableName> tableNameMap = new LinkedHashMap<ActualTableName, LogicTableName>();
        tableNameMap.put(new ActualTableName(jobConfig.getSourceTableName()), new LogicTableName(jobConfig.getTargetTableName()));
        Map tableNameSchemaMap = TableNameSchemaNameMapping.convert((String)jobConfig.getSourceSchemaName(), Collections.singletonList(jobConfig.getTargetTableName()));
        TableNameSchemaNameMapping tableNameSchemaNameMapping = new TableNameSchemaNameMapping(tableNameSchemaMap);
        CreateTableConfiguration createTableConfig = this.buildCreateTableConfiguration(jobConfig);
        DumperConfiguration dumperConfig = this.buildDumperConfiguration(jobConfig.getJobId(), jobConfig.getSourceResourceName(), jobConfig.getSource(), tableNameMap, tableNameSchemaNameMapping);
        ImporterConfiguration importerConfig = this.buildImporterConfiguration(jobConfig, pipelineProcessConfig, Collections.emptyMap(), tableNameSchemaNameMapping);
        MigrationTaskConfiguration result = new MigrationTaskConfiguration(jobConfig.getSourceResourceName(), createTableConfig, dumperConfig, importerConfig);
        log.info("buildTaskConfiguration, sourceResourceName={}, result={}", (Object)jobConfig.getSourceResourceName(), (Object)result);
        return result;
    }

    private CreateTableConfiguration buildCreateTableConfiguration(MigrationJobConfiguration jobConfig) {
        String sourceSchemaName = jobConfig.getSourceSchemaName();
        String targetSchemaName = DatabaseTypeFactory.getInstance((String)jobConfig.getTargetDatabaseType()).isSchemaAvailable() ? sourceSchemaName : null;
        CreateTableConfiguration.CreateTableEntry createTableEntry = new CreateTableConfiguration.CreateTableEntry(jobConfig.getSource(), new SchemaTableName(new SchemaName(sourceSchemaName), new TableName(jobConfig.getSourceTableName())), jobConfig.getTarget(), new SchemaTableName(new SchemaName(targetSchemaName), new TableName(jobConfig.getTargetTableName())));
        return new CreateTableConfiguration(Collections.singletonList(createTableEntry));
    }

    private DumperConfiguration buildDumperConfiguration(String jobId, String dataSourceName, PipelineDataSourceConfiguration sourceDataSource, Map<ActualTableName, LogicTableName> tableNameMap, TableNameSchemaNameMapping tableNameSchemaNameMapping) {
        DumperConfiguration result = new DumperConfiguration();
        result.setJobId(jobId);
        result.setDataSourceName(dataSourceName);
        result.setDataSourceConfig(sourceDataSource);
        result.setTableNameMap(tableNameMap);
        result.setTableNameSchemaNameMapping(tableNameSchemaNameMapping);
        return result;
    }

    private ImporterConfiguration buildImporterConfiguration(MigrationJobConfiguration jobConfig, PipelineProcessConfiguration pipelineProcessConfig, Map<LogicTableName, Set<String>> shardingColumnsMap, TableNameSchemaNameMapping tableNameSchemaNameMapping) {
        int batchSize = pipelineProcessConfig.getWrite().getBatchSize();
        int retryTimes = jobConfig.getRetryTimes();
        int concurrency = jobConfig.getConcurrency();
        MigrationProcessContext migrationProcessContext = new MigrationProcessContext(jobConfig.getJobId(), pipelineProcessConfig);
        return new ImporterConfiguration(jobConfig.getTarget(), this.unmodifiable(shardingColumnsMap), tableNameSchemaNameMapping, batchSize, migrationProcessContext.getWriteRateLimitAlgorithm(), retryTimes, concurrency);
    }

    private Map<LogicTableName, Set<String>> unmodifiable(Map<LogicTableName, Set<String>> shardingColumnsMap) {
        HashMap<LogicTableName, Set<String>> result = new HashMap<LogicTableName, Set<String>>(shardingColumnsMap.size());
        for (Map.Entry<LogicTableName, Set<String>> entry : shardingColumnsMap.entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public MigrationProcessContext buildPipelineProcessContext(PipelineJobConfiguration pipelineJobConfig) {
        PipelineProcessConfiguration processConfig = this.showProcessConfiguration();
        return new MigrationProcessContext(pipelineJobConfig.getJobId(), processConfig);
    }

    @Override
    protected PipelineDataConsistencyChecker buildPipelineDataConsistencyChecker(PipelineJobConfiguration pipelineJobConfig, InventoryIncrementalProcessContext processContext, ConsistencyCheckJobItemContext checkJobItemContext) {
        return new MigrationDataConsistencyChecker((MigrationJobConfiguration)pipelineJobConfig, processContext, checkJobItemContext);
    }

    @Override
    public void startDisabledJob(String jobId) {
        super.startDisabledJob(jobId);
        PipelineAPIFactory.getGovernanceRepositoryAPI().getCheckLatestJobId(jobId).ifPresent(optional -> {
            try {
                ConsistencyCheckJobAPIFactory.getInstance().startDisabledJob((String)optional);
            }
            catch (RuntimeException ex) {
                log.warn("start related check job failed, check job id: {}, error: {}", optional, (Object)ex.getMessage());
            }
        });
    }

    @Override
    public void stop(String jobId) {
        PipelineAPIFactory.getGovernanceRepositoryAPI().getCheckLatestJobId(jobId).ifPresent(optional -> {
            try {
                ConsistencyCheckJobAPIFactory.getInstance().stop((String)optional);
            }
            catch (RuntimeException ex) {
                log.warn("stop related check job failed, check job id: {}, error: {}", optional, (Object)ex.getMessage());
            }
        });
        super.stop(jobId);
    }

    public void rollback(String jobId) throws SQLException {
        log.info("Rollback job {}", (Object)jobId);
        long startTimeMillis = System.currentTimeMillis();
        this.dropCheckJobs(jobId);
        this.stop(jobId);
        this.cleanTempTableOnRollback(jobId);
        this.dropJob(jobId);
        log.info("Rollback cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    private void dropCheckJobs(String jobId) {
        Collection<String> checkJobIds = PipelineAPIFactory.getGovernanceRepositoryAPI().listCheckJobIds(jobId);
        if (checkJobIds.isEmpty()) {
            return;
        }
        log.info("dropCheckJobs start...");
        long startTimeMillis = System.currentTimeMillis();
        for (String each : checkJobIds) {
            try {
                this.dropJob(each);
            }
            catch (RuntimeException ex) {
                log.info("drop check job failed, check job id: {}, error: {}", (Object)each, (Object)ex.getMessage());
            }
        }
        log.info("dropCheckJobs cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    private void cleanTempTableOnRollback(String jobId) throws SQLException {
        MigrationJobConfiguration jobConfig = this.getJobConfiguration(jobId);
        String targetTableName = jobConfig.getTargetTableName();
        String targetSchemaName = jobConfig.getSourceSchemaName();
        PipelineSQLBuilder pipelineSQLBuilder = PipelineSQLBuilderFactory.getInstance(jobConfig.getTargetDatabaseType());
        try (PipelineDataSourceWrapper dataSource = PipelineDataSourceFactory.newInstance(jobConfig.getTarget());
             Connection connection = dataSource.getConnection();){
            String sql = pipelineSQLBuilder.buildDropSQL(targetSchemaName, targetTableName);
            log.info("cleanTempTableOnRollback, targetSchemaName={}, targetTableName={}, sql={}", new Object[]{targetSchemaName, targetTableName, sql});
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                preparedStatement.execute();
            }
        }
    }

    public void commit(String jobId) {
        this.checkModeConfig();
        log.info("Commit job {}", (Object)jobId);
        long startTimeMillis = System.currentTimeMillis();
        this.dropCheckJobs(jobId);
        this.stop(jobId);
        this.dropJob(jobId);
        log.info("Commit cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    public void addMigrationSourceResources(Map<String, DataSourceProperties> dataSourcePropsMap) {
        log.info("Add migration source resources {}", dataSourcePropsMap.keySet());
        Object existDataSources = this.dataSourcePersistService.load(this.getJobType());
        HashSet<String> duplicateDataSourceNames = new HashSet<String>(dataSourcePropsMap.size(), 1.0f);
        for (Map.Entry<String, DataSourceProperties> entry : dataSourcePropsMap.entrySet()) {
            if (!existDataSources.containsKey(entry.getKey())) continue;
            duplicateDataSourceNames.add(entry.getKey());
        }
        ShardingSpherePreconditions.checkState((boolean)duplicateDataSourceNames.isEmpty(), () -> new AddMigrationSourceResourceException(duplicateDataSourceNames));
        LinkedHashMap<String, DataSourceProperties> result = new LinkedHashMap<String, DataSourceProperties>((Map<String, DataSourceProperties>)existDataSources);
        result.putAll(dataSourcePropsMap);
        this.dataSourcePersistService.persist(this.getJobType(), (Map<String, DataSourceProperties>)result);
    }

    public void dropMigrationSourceResources(Collection<String> resourceNames) {
        Object metaDataDataSource = this.dataSourcePersistService.load(this.getJobType());
        List noExistResources = resourceNames.stream().filter(arg_0 -> MigrationJobAPIImpl.lambda$dropMigrationSourceResources$3((Map)metaDataDataSource, arg_0)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)noExistResources.isEmpty(), () -> new DropMigrationSourceResourceException(resourceNames));
        for (String each : resourceNames) {
            metaDataDataSource.remove(each);
        }
        this.dataSourcePersistService.persist(this.getJobType(), (Map<String, DataSourceProperties>)metaDataDataSource);
    }

    public Collection<Collection<Object>> listMigrationSourceResources() {
        Object dataSourcePropertiesMap = this.dataSourcePersistService.load(this.getJobType());
        ArrayList<Collection<Object>> result = new ArrayList<Collection<Object>>(dataSourcePropertiesMap.size());
        for (Map.Entry entry : dataSourcePropertiesMap.entrySet()) {
            String dataSourceName = (String)entry.getKey();
            DataSourceProperties value = (DataSourceProperties)entry.getValue();
            LinkedList<Object> props = new LinkedList<Object>();
            props.add(dataSourceName);
            String url = String.valueOf(value.getConnectionPropertySynonyms().getStandardProperties().get("url"));
            DatabaseType databaseType = DatabaseTypeEngine.getDatabaseType((String)url);
            props.add(databaseType.getType());
            DataSourceMetaData metaData = databaseType.getDataSourceMetaData(url, "");
            props.add(metaData.getHostname());
            props.add(metaData.getPort());
            props.add(metaData.getCatalog());
            Map standardProps = value.getPoolPropertySynonyms().getStandardProperties();
            props.add(this.getStandardProperty(standardProps, "connectionTimeoutMilliseconds"));
            props.add(this.getStandardProperty(standardProps, "idleTimeoutMilliseconds"));
            props.add(this.getStandardProperty(standardProps, "maxLifetimeMilliseconds"));
            props.add(this.getStandardProperty(standardProps, "maxPoolSize"));
            props.add(this.getStandardProperty(standardProps, "minPoolSize"));
            props.add(this.getStandardProperty(standardProps, "readOnly"));
            Map otherProps = value.getCustomDataSourceProperties().getProperties();
            props.add(otherProps.isEmpty() ? "" : new Gson().toJson((Object)otherProps));
            result.add(props);
        }
        return result;
    }

    private String getStandardProperty(Map<String, Object> standardProps, String key) {
        if (standardProps.containsKey(key) && null != standardProps.get(key)) {
            return standardProps.get(key).toString();
        }
        return "";
    }

    public String createJobAndStart(CreateMigrationJobParameter parameter) {
        YamlMigrationJobConfiguration result = new YamlMigrationJobConfiguration();
        Object metaDataDataSource = this.dataSourcePersistService.load(JobType.MIGRATION);
        Map sourceDataSourceProps = this.swapper.swapToMap((DataSourceProperties)metaDataDataSource.get(parameter.getSourceResourceName()));
        YamlPipelineDataSourceConfiguration sourcePipelineDataSourceConfiguration = this.createYamlPipelineDataSourceConfiguration("JDBC", YamlEngine.marshal((Object)sourceDataSourceProps));
        result.setSource(sourcePipelineDataSourceConfiguration);
        result.setSourceResourceName(parameter.getSourceResourceName());
        StandardPipelineDataSourceConfiguration sourceDataSourceConfig = new StandardPipelineDataSourceConfiguration(sourceDataSourceProps);
        DatabaseType sourceDatabaseType = sourceDataSourceConfig.getDatabaseType();
        result.setSourceDatabaseType(sourceDatabaseType.getType());
        String sourceSchemaName = null == parameter.getSourceSchemaName() && sourceDatabaseType.isSchemaAvailable() ? PipelineSchemaUtil.getDefaultSchema((PipelineDataSourceConfiguration)sourceDataSourceConfig) : parameter.getSourceSchemaName();
        result.setSourceSchemaName(sourceSchemaName);
        result.setSourceTableName(parameter.getSourceTableName());
        HashMap<String, Map<String, Object>> targetDataSourceProperties = new HashMap<String, Map<String, Object>>();
        ShardingSphereDatabase targetDatabase = PipelineContext.getContextManager().getMetaDataContexts().getMetaData().getDatabase(parameter.getTargetDatabaseName());
        for (Map.Entry entry : targetDatabase.getResourceMetaData().getDataSources().entrySet()) {
            Map dataSourceProps = this.swapper.swapToMap(DataSourcePropertiesCreator.create((DataSource)((DataSource)entry.getValue())));
            targetDataSourceProperties.put((String)entry.getKey(), dataSourceProps);
        }
        String targetDatabaseName = parameter.getTargetDatabaseName();
        YamlRootConfiguration targetRootConfig = this.getYamlRootConfiguration(targetDatabaseName, targetDataSourceProperties, targetDatabase.getRuleMetaData().getConfigurations());
        ShardingSpherePipelineDataSourceConfiguration targetPipelineDataSource = new ShardingSpherePipelineDataSourceConfiguration(targetRootConfig);
        result.setTarget(this.createYamlPipelineDataSourceConfiguration(targetPipelineDataSource.getType(), YamlEngine.marshal((Object)targetPipelineDataSource.getDataSourceConfiguration())));
        result.setTargetDatabaseType(targetPipelineDataSource.getDatabaseType().getType());
        result.setTargetDatabaseName(targetDatabaseName);
        result.setTargetTableName(parameter.getTargetTableName());
        try (PipelineDataSourceWrapper dataSource = PipelineDataSourceFactory.newInstance((PipelineDataSourceConfiguration)sourceDataSourceConfig);){
            StandardPipelineTableMetaDataLoader metaDataLoader = new StandardPipelineTableMetaDataLoader(dataSource);
            YamlPipelineColumnMetaData uniqueKeyColumn = new YamlPipelineColumnMetaDataSwapper().swapToYamlConfiguration(PipelineTableMetaDataUtil.getUniqueKeyColumn(sourceSchemaName, parameter.getSourceTableName(), metaDataLoader));
            result.setUniqueKeyColumn(uniqueKeyColumn);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        this.extendYamlJobConfiguration(result);
        MigrationJobConfiguration jobConfig = new YamlMigrationJobConfigurationSwapper().swapToObject(result);
        this.start((PipelineJobConfiguration)jobConfig);
        return jobConfig.getJobId();
    }

    private YamlRootConfiguration getYamlRootConfiguration(String databaseName, Map<String, Map<String, Object>> yamlDataSources, Collection<RuleConfiguration> rules) {
        YamlRootConfiguration result = new YamlRootConfiguration();
        result.setDatabaseName(databaseName);
        result.setDataSources(yamlDataSources);
        Collection yamlRuleConfigurations = this.swapperEngine.swapToYamlRuleConfigurations(rules);
        result.setRules(yamlRuleConfigurations);
        return result;
    }

    private YamlPipelineDataSourceConfiguration createYamlPipelineDataSourceConfiguration(String type, String parameter) {
        YamlPipelineDataSourceConfiguration result = new YamlPipelineDataSourceConfiguration();
        result.setType(type);
        result.setParameter(parameter);
        return result;
    }

    public JobType getJobType() {
        return JobType.MIGRATION;
    }

    @Override
    protected String getJobClassName() {
        return MigrationJob.class.getName();
    }

    private static /* synthetic */ boolean lambda$dropMigrationSourceResources$3(Map metaDataDataSource, String each) {
        return !metaDataDataSource.containsKey(each);
    }
}

