/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.api.config.job.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.job.progress.listener.PipelineJobProgressUpdatedParameter;
import org.apache.shardingsphere.data.pipeline.api.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistService;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.StandardPipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationProcessContext;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationTaskConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationJobItemContext
implements InventoryIncrementalJobItemContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationJobItemContext.class);
    private final String jobId;
    private final int shardingItem;
    private final String dataSourceName;
    private volatile boolean stopping;
    private volatile JobStatus status = JobStatus.RUNNING;
    private final InventoryIncrementalJobItemProgress initProgress;
    private final MigrationTaskConfiguration taskConfig;
    private final Collection<InventoryTask> inventoryTasks = new LinkedList<InventoryTask>();
    private final Collection<IncrementalTask> incrementalTasks = new LinkedList<IncrementalTask>();
    private final AtomicLong processedRecordsCount = new AtomicLong(0L);
    private final MigrationJobConfiguration jobConfig;
    private final MigrationProcessContext jobProcessContext;
    private final PipelineDataSourceManager dataSourceManager;
    private final LazyInitializer<PipelineDataSourceWrapper> sourceDataSourceLazyInitializer = new LazyInitializer<PipelineDataSourceWrapper>(){

        protected PipelineDataSourceWrapper initialize() {
            return MigrationJobItemContext.this.dataSourceManager.getDataSource(MigrationJobItemContext.this.taskConfig.getDumperConfig().getDataSourceConfig());
        }
    };
    private final LazyInitializer<PipelineTableMetaDataLoader> sourceMetaDataLoaderLazyInitializer = new LazyInitializer<PipelineTableMetaDataLoader>(){

        protected PipelineTableMetaDataLoader initialize() throws ConcurrentException {
            return new StandardPipelineTableMetaDataLoader((PipelineDataSourceWrapper)MigrationJobItemContext.this.sourceDataSourceLazyInitializer.get());
        }
    };

    public MigrationJobItemContext(MigrationJobConfiguration jobConfig, int shardingItem, InventoryIncrementalJobItemProgress initProgress, MigrationProcessContext jobProcessContext, MigrationTaskConfiguration taskConfig, PipelineDataSourceManager dataSourceManager) {
        this.jobConfig = jobConfig;
        this.jobId = jobConfig.getJobId();
        this.shardingItem = shardingItem;
        this.dataSourceName = taskConfig.getDataSourceName();
        this.initProgress = initProgress;
        if (null != initProgress) {
            this.processedRecordsCount.set(initProgress.getProcessedRecordsCount());
        }
        this.jobProcessContext = jobProcessContext;
        this.taskConfig = taskConfig;
        this.dataSourceManager = dataSourceManager;
    }

    public PipelineDataSourceWrapper getSourceDataSource() {
        return (PipelineDataSourceWrapper)this.sourceDataSourceLazyInitializer.get();
    }

    @Override
    public PipelineTableMetaDataLoader getSourceMetaDataLoader() {
        return (PipelineTableMetaDataLoader)this.sourceMetaDataLoaderLazyInitializer.get();
    }

    public boolean isSourceTargetDatabaseTheSame() {
        return this.jobConfig.getSourceDatabaseType().equalsIgnoreCase(this.jobConfig.getTargetDatabaseType());
    }

    public void onProgressUpdated(PipelineJobProgressUpdatedParameter parameter) {
        this.processedRecordsCount.addAndGet(parameter.getProcessedRecordsCount());
        PipelineJobProgressPersistService.notifyPersist(this.jobId, this.shardingItem);
    }

    @Override
    public long getProcessedRecordsCount() {
        return this.processedRecordsCount.get();
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Generated
    public boolean isStopping() {
        return this.stopping;
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Override
    @Generated
    public InventoryIncrementalJobItemProgress getInitProgress() {
        return this.initProgress;
    }

    @Generated
    public MigrationTaskConfiguration getTaskConfig() {
        return this.taskConfig;
    }

    @Override
    @Generated
    public Collection<InventoryTask> getInventoryTasks() {
        return this.inventoryTasks;
    }

    @Override
    @Generated
    public Collection<IncrementalTask> getIncrementalTasks() {
        return this.incrementalTasks;
    }

    @Generated
    public MigrationJobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    @Override
    @Generated
    public MigrationProcessContext getJobProcessContext() {
        return this.jobProcessContext;
    }

    @Override
    @Generated
    public PipelineDataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    @Generated
    public LazyInitializer<PipelineDataSourceWrapper> getSourceDataSourceLazyInitializer() {
        return this.sourceDataSourceLazyInitializer;
    }

    @Generated
    public LazyInitializer<PipelineTableMetaDataLoader> getSourceMetaDataLoaderLazyInitializer() {
        return this.sourceMetaDataLoaderLazyInitializer;
    }

    @Generated
    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }
}

