/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration;

import java.sql.SQLException;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.CreateTableConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.InventoryDumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.api.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.api.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithGetBinlogPositionException;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobCenter;
import org.apache.shardingsphere.data.pipeline.core.prepare.InventoryTaskSplitter;
import org.apache.shardingsphere.data.pipeline.core.prepare.PipelineJobPreparerUtils;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetTablesParameter;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobItemContext;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreator;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.lock.LockDefinition;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.mode.lock.ExclusiveLockDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationJobPreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationJobPreparer.class);
    private static final MigrationJobAPI JOB_API = MigrationJobAPIFactory.getInstance();

    public void prepare(MigrationJobItemContext jobItemContext) throws SQLException {
        PipelineJobPreparerUtils.checkSourceDataSource(jobItemContext.getJobConfig().getSourceDatabaseType(), Collections.singleton(jobItemContext.getSourceDataSource()));
        if (jobItemContext.isStopping()) {
            log.info("prepare, job is stopping, jobId={}", (Object)jobItemContext.getJobId());
            PipelineJobCenter.stop(jobItemContext.getJobId());
            return;
        }
        this.prepareAndCheckTargetWithLock(jobItemContext);
        if (jobItemContext.isStopping()) {
            log.info("prepare, job is stopping, jobId={}", (Object)jobItemContext.getJobId());
            PipelineJobCenter.stop(jobItemContext.getJobId());
            return;
        }
        if (PipelineJobPreparerUtils.isIncrementalSupported(jobItemContext.getJobConfig().getSourceDatabaseType())) {
            this.initIncrementalTasks(jobItemContext);
            if (jobItemContext.isStopping()) {
                log.info("prepare, job is stopping, jobId={}", (Object)jobItemContext.getJobId());
                PipelineJobCenter.stop(jobItemContext.getJobId());
                return;
            }
        }
        this.initInventoryTasks(jobItemContext);
        log.info("prepare, jobId={}, shardingItem={}, inventoryTasks={}, incrementalTasks={}", new Object[]{jobItemContext.getJobId(), jobItemContext.getShardingItem(), jobItemContext.getInventoryTasks(), jobItemContext.getIncrementalTasks()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndCheckTargetWithLock(MigrationJobItemContext jobItemContext) throws SQLException {
        MigrationJobConfiguration jobConfig = jobItemContext.getJobConfig();
        String lockName = "prepare-" + jobConfig.getJobId();
        LockContext lockContext = PipelineContext.getContextManager().getInstanceContext().getLockContext();
        ExclusiveLockDefinition lockDefinition = new ExclusiveLockDefinition(lockName);
        if (null == JOB_API.getJobItemProgress(jobItemContext.getJobId(), jobItemContext.getShardingItem())) {
            JOB_API.persistJobItemProgress(jobItemContext);
        }
        long startTimeMillis = System.currentTimeMillis();
        if (lockContext.tryLock((LockDefinition)lockDefinition, 180000L)) {
            block5: {
                log.info("try lock success, jobId={}, shardingItem={}, cost {} ms", new Object[]{jobConfig.getJobId(), jobItemContext.getShardingItem(), System.currentTimeMillis() - startTimeMillis});
                try {
                    boolean prepareFlag;
                    InventoryIncrementalJobItemProgress jobItemProgress = JOB_API.getJobItemProgress(jobItemContext.getJobId(), jobItemContext.getShardingItem());
                    boolean bl = prepareFlag = JobStatus.PREPARING.equals((Object)jobItemProgress.getStatus()) || JobStatus.RUNNING.equals((Object)jobItemProgress.getStatus()) || JobStatus.PREPARING_FAILURE.equals((Object)jobItemProgress.getStatus());
                    if (!prepareFlag) break block5;
                    log.info("execute prepare, jobId={}, shardingItem={}, jobStatus={}", new Object[]{jobConfig.getJobId(), jobItemContext.getShardingItem(), jobItemProgress.getStatus()});
                    jobItemContext.setStatus(JobStatus.PREPARING);
                    JOB_API.updateJobItemStatus(jobConfig.getJobId(), jobItemContext.getShardingItem(), JobStatus.PREPARING);
                    this.prepareAndCheckTarget(jobItemContext);
                    for (int i = 0; i <= jobItemContext.getJobConfig().getJobShardingCount(); ++i) {
                        JOB_API.updateJobItemStatus(jobConfig.getJobId(), i, JobStatus.PREPARE_SUCCESS);
                    }
                }
                catch (Throwable throwable) {
                    log.info("unlock, jobId={}, shardingItem={}, cost {} ms", new Object[]{jobConfig.getJobId(), jobItemContext.getShardingItem(), System.currentTimeMillis() - startTimeMillis});
                    lockContext.unlock((LockDefinition)lockDefinition);
                    throw throwable;
                }
            }
            log.info("unlock, jobId={}, shardingItem={}, cost {} ms", new Object[]{jobConfig.getJobId(), jobItemContext.getShardingItem(), System.currentTimeMillis() - startTimeMillis});
            lockContext.unlock((LockDefinition)lockDefinition);
        }
    }

    private void prepareAndCheckTarget(MigrationJobItemContext jobItemContext) throws SQLException {
        InventoryIncrementalJobItemProgress initProgress;
        if (jobItemContext.isSourceTargetDatabaseTheSame()) {
            log.info("prepare target ...");
            this.prepareTarget(jobItemContext);
        }
        if (null == (initProgress = jobItemContext.getInitProgress()) || initProgress.getStatus() == JobStatus.PREPARING_FAILURE) {
            PipelineDataSourceWrapper targetDataSource = jobItemContext.getDataSourceManager().getDataSource(jobItemContext.getTaskConfig().getImporterConfig().getDataSourceConfig());
            PipelineJobPreparerUtils.checkTargetDataSource(jobItemContext.getJobConfig().getTargetDatabaseType(), jobItemContext.getTaskConfig().getImporterConfig(), Collections.singletonList(targetDataSource));
        }
    }

    private void prepareTarget(MigrationJobItemContext jobItemContext) throws SQLException {
        MigrationJobConfiguration jobConfig = jobItemContext.getJobConfig();
        String targetDatabaseType = jobConfig.getTargetDatabaseType();
        CreateTableConfiguration createTableConfig = jobItemContext.getTaskConfig().getCreateTableConfig();
        PrepareTargetSchemasParameter prepareTargetSchemasParameter = new PrepareTargetSchemasParameter(DatabaseTypeFactory.getInstance((String)targetDatabaseType), createTableConfig, jobItemContext.getDataSourceManager());
        PipelineJobPreparerUtils.prepareTargetSchema(targetDatabaseType, prepareTargetSchemasParameter);
        ShardingSphereSQLParserEngine sqlParserEngine = PipelineJobPreparerUtils.getSQLParserEngine(jobConfig.getTargetDatabaseName());
        PrepareTargetTablesParameter prepareTargetTablesParameter = new PrepareTargetTablesParameter(createTableConfig, jobItemContext.getDataSourceManager(), sqlParserEngine);
        PipelineJobPreparerUtils.prepareTargetTables(targetDatabaseType, prepareTargetTablesParameter);
    }

    private void initInventoryTasks(MigrationJobItemContext jobItemContext) {
        InventoryDumperConfiguration inventoryDumperConfig = new InventoryDumperConfiguration(jobItemContext.getTaskConfig().getDumperConfig());
        PipelineColumnMetaData uniqueKeyColumn = jobItemContext.getJobConfig().getUniqueKeyColumn();
        inventoryDumperConfig.setUniqueKey(uniqueKeyColumn.getName());
        inventoryDumperConfig.setUniqueKeyDataType(Integer.valueOf(uniqueKeyColumn.getDataType()));
        InventoryTaskSplitter inventoryTaskSplitter = new InventoryTaskSplitter(jobItemContext.getSourceDataSource(), inventoryDumperConfig, jobItemContext.getTaskConfig().getImporterConfig());
        jobItemContext.getInventoryTasks().addAll(inventoryTaskSplitter.splitInventoryData(jobItemContext));
    }

    private void initIncrementalTasks(MigrationJobItemContext jobItemContext) {
        PipelineChannelCreator pipelineChannelCreator = jobItemContext.getJobProcessContext().getPipelineChannelCreator();
        MigrationTaskConfiguration taskConfig = jobItemContext.getTaskConfig();
        PipelineDataSourceManager dataSourceManager = jobItemContext.getDataSourceManager();
        JobItemIncrementalTasksProgress initIncremental = null == jobItemContext.getInitProgress() ? null : jobItemContext.getInitProgress().getIncremental();
        try {
            taskConfig.getDumperConfig().setPosition(PipelineJobPreparerUtils.getIncrementalPosition(initIncremental, taskConfig.getDumperConfig(), dataSourceManager));
        }
        catch (SQLException ex) {
            throw new PrepareJobWithGetBinlogPositionException(jobItemContext.getJobId(), ex);
        }
        PipelineTableMetaDataLoader sourceMetaDataLoader = jobItemContext.getSourceMetaDataLoader();
        ExecuteEngine incrementalExecuteEngine = jobItemContext.getJobProcessContext().getIncrementalExecuteEngine();
        IncrementalTask incrementalTask = new IncrementalTask(taskConfig.getImporterConfig().getConcurrency(), taskConfig.getDumperConfig(), taskConfig.getImporterConfig(), pipelineChannelCreator, dataSourceManager, sourceMetaDataLoader, incrementalExecuteEngine, jobItemContext);
        jobItemContext.getIncrementalTasks().add(incrementalTask);
    }

    public void cleanup(MigrationJobConfiguration jobConfig) {
        try {
            PipelineJobPreparerUtils.destroyPosition(jobConfig.getJobId(), jobConfig.getSource());
        }
        catch (SQLException ex) {
            log.warn("job destroying failed", (Throwable)ex);
        }
    }
}

