/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.yaml.job;

import com.google.common.base.Preconditions;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.job.yaml.YamlPipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.yaml.metadata.YamlPipelineColumnMetaData;

public final class YamlMigrationJobConfiguration
implements YamlPipelineJobConfiguration {
    private String jobId;
    private String sourceResourceName;
    private String targetDatabaseName;
    private String sourceSchemaName;
    private String sourceDatabaseType;
    private String targetDatabaseType;
    private String sourceTableName;
    private String targetTableName;
    private YamlPipelineDataSourceConfiguration source;
    private YamlPipelineDataSourceConfiguration target;
    private String tablesFirstDataNodes;
    private List<String> jobShardingDataNodes;
    private YamlPipelineColumnMetaData uniqueKeyColumn;
    private int concurrency = 3;
    private int retryTimes = 3;

    public void setSource(YamlPipelineDataSourceConfiguration source) {
        this.checkParameters(source);
        this.source = source;
    }

    public void setTarget(YamlPipelineDataSourceConfiguration target) {
        this.checkParameters(target);
        this.target = target;
    }

    private void checkParameters(YamlPipelineDataSourceConfiguration yamlConfig) {
        Preconditions.checkNotNull((Object)yamlConfig);
        Preconditions.checkNotNull((Object)yamlConfig.getType());
        Preconditions.checkNotNull((Object)yamlConfig.getParameter());
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getSourceResourceName() {
        return this.sourceResourceName;
    }

    @Generated
    public String getTargetDatabaseName() {
        return this.targetDatabaseName;
    }

    @Generated
    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    @Generated
    public String getSourceDatabaseType() {
        return this.sourceDatabaseType;
    }

    @Generated
    public String getTargetDatabaseType() {
        return this.targetDatabaseType;
    }

    @Generated
    public String getSourceTableName() {
        return this.sourceTableName;
    }

    @Generated
    public String getTargetTableName() {
        return this.targetTableName;
    }

    @Generated
    public YamlPipelineDataSourceConfiguration getSource() {
        return this.source;
    }

    @Generated
    public YamlPipelineDataSourceConfiguration getTarget() {
        return this.target;
    }

    @Generated
    public String getTablesFirstDataNodes() {
        return this.tablesFirstDataNodes;
    }

    @Generated
    public List<String> getJobShardingDataNodes() {
        return this.jobShardingDataNodes;
    }

    @Generated
    public YamlPipelineColumnMetaData getUniqueKeyColumn() {
        return this.uniqueKeyColumn;
    }

    @Generated
    public int getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public int getRetryTimes() {
        return this.retryTimes;
    }

    @Generated
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Generated
    public void setSourceResourceName(String sourceResourceName) {
        this.sourceResourceName = sourceResourceName;
    }

    @Generated
    public void setTargetDatabaseName(String targetDatabaseName) {
        this.targetDatabaseName = targetDatabaseName;
    }

    @Generated
    public void setSourceSchemaName(String sourceSchemaName) {
        this.sourceSchemaName = sourceSchemaName;
    }

    @Generated
    public void setSourceDatabaseType(String sourceDatabaseType) {
        this.sourceDatabaseType = sourceDatabaseType;
    }

    @Generated
    public void setTargetDatabaseType(String targetDatabaseType) {
        this.targetDatabaseType = targetDatabaseType;
    }

    @Generated
    public void setSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
    }

    @Generated
    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }

    @Generated
    public void setTablesFirstDataNodes(String tablesFirstDataNodes) {
        this.tablesFirstDataNodes = tablesFirstDataNodes;
    }

    @Generated
    public void setJobShardingDataNodes(List<String> jobShardingDataNodes) {
        this.jobShardingDataNodes = jobShardingDataNodes;
    }

    @Generated
    public void setUniqueKeyColumn(YamlPipelineColumnMetaData uniqueKeyColumn) {
        this.uniqueKeyColumn = uniqueKeyColumn;
    }

    @Generated
    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    @Generated
    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    @Generated
    public String toString() {
        return "YamlMigrationJobConfiguration(jobId=" + this.getJobId() + ", sourceResourceName=" + this.getSourceResourceName() + ", targetDatabaseName=" + this.getTargetDatabaseName() + ", sourceSchemaName=" + this.getSourceSchemaName() + ", sourceDatabaseType=" + this.getSourceDatabaseType() + ", targetDatabaseType=" + this.getTargetDatabaseType() + ", sourceTableName=" + this.getSourceTableName() + ", targetTableName=" + this.getTargetTableName() + ", tablesFirstDataNodes=" + this.getTablesFirstDataNodes() + ", jobShardingDataNodes=" + this.getJobShardingDataNodes() + ", uniqueKeyColumn=" + this.getUniqueKeyColumn() + ", concurrency=" + this.getConcurrency() + ", retryTimes=" + this.getRetryTimes() + ")";
    }
}

