/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.yaml.job;

import org.apache.shardingsphere.data.pipeline.api.config.job.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlPipelineDataSourceConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.yaml.job.YamlMigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.yaml.metadata.YamlPipelineColumnMetaDataSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.util.yaml.swapper.YamlConfigurationSwapper;

public final class YamlMigrationJobConfigurationSwapper
implements YamlConfigurationSwapper<YamlMigrationJobConfiguration, MigrationJobConfiguration> {
    private final YamlPipelineDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlPipelineDataSourceConfigurationSwapper();
    private final YamlPipelineColumnMetaDataSwapper pipelineColumnMetaDataSwapper = new YamlPipelineColumnMetaDataSwapper();

    public YamlMigrationJobConfiguration swapToYamlConfiguration(MigrationJobConfiguration data) {
        YamlMigrationJobConfiguration result = new YamlMigrationJobConfiguration();
        result.setJobId(data.getJobId());
        result.setSourceResourceName(data.getSourceResourceName());
        result.setTargetDatabaseName(data.getTargetDatabaseName());
        result.setSourceDatabaseType(data.getSourceDatabaseType());
        result.setTargetDatabaseType(data.getTargetDatabaseType());
        result.setSourceSchemaName(data.getSourceSchemaName());
        result.setSourceTableName(data.getSourceTableName());
        result.setTargetTableName(data.getTargetTableName());
        result.setSource(this.dataSourceConfigSwapper.swapToYamlConfiguration(data.getSource()));
        result.setTarget(this.dataSourceConfigSwapper.swapToYamlConfiguration(data.getTarget()));
        result.setTablesFirstDataNodes(data.getTablesFirstDataNodes());
        result.setJobShardingDataNodes(data.getJobShardingDataNodes());
        result.setUniqueKeyColumn(this.pipelineColumnMetaDataSwapper.swapToYamlConfiguration(data.getUniqueKeyColumn()));
        result.setConcurrency(data.getConcurrency());
        result.setRetryTimes(data.getRetryTimes());
        return result;
    }

    public MigrationJobConfiguration swapToObject(YamlMigrationJobConfiguration yamlConfig) {
        return new MigrationJobConfiguration(yamlConfig.getJobId(), yamlConfig.getSourceResourceName(), yamlConfig.getTargetDatabaseName(), yamlConfig.getSourceSchemaName(), yamlConfig.getSourceDatabaseType(), yamlConfig.getTargetDatabaseType(), yamlConfig.getSourceTableName(), yamlConfig.getTargetTableName(), this.dataSourceConfigSwapper.swapToObject(yamlConfig.getSource()), this.dataSourceConfigSwapper.swapToObject(yamlConfig.getTarget()), yamlConfig.getTablesFirstDataNodes(), yamlConfig.getJobShardingDataNodes(), this.pipelineColumnMetaDataSwapper.swapToObject(yamlConfig.getUniqueKeyColumn()), yamlConfig.getConcurrency(), yamlConfig.getRetryTimes());
    }

    public MigrationJobConfiguration swapToObject(String jobParameter) {
        return this.swapToObject((YamlMigrationJobConfiguration)YamlEngine.unmarshal((String)jobParameter, YamlMigrationJobConfiguration.class, (boolean)true));
    }
}

