/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.checker;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class DatabaseDiscoveryRuleConfigurationChecker
implements RuleConfigurationChecker<DatabaseDiscoveryRuleConfiguration> {
    public void check(String databaseName, DatabaseDiscoveryRuleConfiguration config, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules) {
        config.getDataSources().forEach(each -> Preconditions.checkState((!each.getDiscoveryTypeName().isEmpty() ? 1 : 0) != 0, (String)"No available database discovery rule configuration in database `%s.", (Object)databaseName));
    }

    public int getOrder() {
        return 40;
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getTypeClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }
}

