/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public abstract class AbstractEncryptRuleConfigurationChecker<T extends RuleConfiguration>
implements RuleConfigurationChecker<T> {
    public final void check(String databaseName, T config, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules) {
        this.checkTableConfiguration(databaseName, this.getTables(config), this.getEncryptors(config));
    }

    private void checkTableConfiguration(String databaseName, Collection<EncryptTableRuleConfiguration> tables, Collection<String> encryptors) {
        for (EncryptTableRuleConfiguration each : tables) {
            for (EncryptColumnRuleConfiguration column : each.getColumns()) {
                this.checkCipherColumnConfiguration(databaseName, encryptors, column);
                this.checkAssistColumnConfiguration(databaseName, encryptors, column);
            }
        }
    }

    private void checkCipherColumnConfiguration(String databaseName, Collection<String> encryptors, EncryptColumnRuleConfiguration column) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)column.getCipherColumn()) ? 1 : 0) != 0, (String)"Cipher column of `%s` can not be null in database `%s`.", (Object)column.getLogicColumn(), (Object)databaseName);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)column.getEncryptorName()) ? 1 : 0) != 0, (String)"Encryptor name of `%s` can not be null in database `%s`.", (Object)column.getLogicColumn(), (Object)databaseName);
        Preconditions.checkState((boolean)encryptors.contains(column.getEncryptorName()), (String)"Can not find encryptor `%s` in database `%s`.", (Object)column.getEncryptorName(), (Object)databaseName);
    }

    private void checkAssistColumnConfiguration(String databaseName, Collection<String> encryptors, EncryptColumnRuleConfiguration column) {
        if (Strings.isNullOrEmpty((String)column.getAssistedQueryColumn()) && Strings.isNullOrEmpty((String)column.getAssistedQueryEncryptorName())) {
            return;
        }
        Preconditions.checkState((!Strings.isNullOrEmpty((String)column.getAssistedQueryColumn()) ? 1 : 0) != 0, (String)"Assisted query column of `%s` can not be null in database `%s`.", (Object)column.getLogicColumn(), (Object)databaseName);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)column.getAssistedQueryEncryptorName()) ? 1 : 0) != 0, (String)"Assisted query encryptor name of `%s` can not be null in database `%s`.", (Object)column.getLogicColumn(), (Object)databaseName);
        Preconditions.checkState((boolean)encryptors.contains(column.getAssistedQueryEncryptorName()), (String)"Can not find assisted query encryptor `%s` in database `%s`.", (Object)column.getAssistedQueryEncryptorName(), (Object)databaseName);
    }

    protected abstract Collection<String> getEncryptors(T var1);

    protected abstract Collection<EncryptTableRuleConfiguration> getTables(T var1);
}

