/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.context.EncryptContextBuilder;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptInsertValueException;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptInsertValuesToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.segment.insert.values.expression.DerivedLiteralExpressionSegment;
import org.apache.shardingsphere.infra.binder.segment.insert.values.expression.DerivedParameterMarkerExpressionSegment;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.InsertValue;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.UseDefaultInsertColumnsToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;

public final class EncryptInsertValuesTokenGenerator
implements OptionalSQLTokenGenerator<InsertStatementContext>,
PreviousSQLTokensAware,
EncryptRuleAware,
DatabaseNameAware {
    private List<SQLToken> previousSQLTokens;
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && !((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getValues().isEmpty();
    }

    public InsertValuesToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional<SQLToken> insertValuesToken = this.findPreviousSQLToken(InsertValuesToken.class);
        if (insertValuesToken.isPresent()) {
            this.processPreviousSQLToken(insertStatementContext, (InsertValuesToken)insertValuesToken.get());
            return (InsertValuesToken)insertValuesToken.get();
        }
        return this.generateNewSQLToken(insertStatementContext);
    }

    private Optional<SQLToken> findPreviousSQLToken(Class<?> sqlToken) {
        for (SQLToken each : this.previousSQLTokens) {
            if (!sqlToken.isAssignableFrom(each.getClass())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private void processPreviousSQLToken(InsertStatementContext insertStatementContext, InsertValuesToken insertValuesToken) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        int count = 0;
        String schemaName = insertStatementContext.getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)insertStatementContext.getDatabaseType(), (String)this.databaseName));
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            this.encryptToken((InsertValue)insertValuesToken.getInsertValues().get(count), schemaName, tableName, insertStatementContext, each);
            ++count;
        }
    }

    private InsertValuesToken generateNewSQLToken(InsertStatementContext insertStatementContext) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Collection insertValuesSegments = ((InsertStatement)insertStatementContext.getSqlStatement()).getValues();
        EncryptInsertValuesToken result = new EncryptInsertValuesToken(this.getStartIndex(insertValuesSegments), this.getStopIndex(insertValuesSegments));
        String schemaName = insertStatementContext.getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)insertStatementContext.getDatabaseType(), (String)this.databaseName));
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            InsertValue insertValueToken = new InsertValue(each.getValueExpressions());
            this.encryptToken(insertValueToken, schemaName, tableName, insertStatementContext, each);
            result.getInsertValues().add(insertValueToken);
        }
        return result;
    }

    private int getStartIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStartIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.min(result, each.getStartIndex());
        }
        return result;
    }

    private int getStopIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStopIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.max(result, each.getStopIndex());
        }
        return result;
    }

    private void encryptToken(InsertValue insertValueToken, String schemaName, String tableName, InsertStatementContext insertStatementContext, InsertValueContext insertValueContext) {
        Optional<SQLToken> useDefaultInsertColumnsToken = this.findPreviousSQLToken(UseDefaultInsertColumnsToken.class);
        Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            Optional<EncryptAlgorithm> encryptor = this.encryptRule.findEncryptor(tableName, columnName);
            if (!encryptor.isPresent()) continue;
            int columnIndex = useDefaultInsertColumnsToken.map(optional -> ((UseDefaultInsertColumnsToken)optional).getColumns().indexOf(columnName)).orElseGet(() -> insertStatementContext.getColumnNames().indexOf(columnName));
            Object originalValue = insertValueContext.getLiteralValue(columnIndex).orElseThrow(() -> new UnsupportedEncryptInsertValueException(columnIndex));
            EncryptContext encryptContext = EncryptContextBuilder.build(this.databaseName, schemaName, tableName, columnName);
            this.addPlainColumn(insertValueToken, columnIndex, encryptContext, insertValueContext, originalValue);
            if (this.encryptRule.findAssistedQueryEncryptor(tableName, columnName).isPresent()) {
                this.addAssistedQueryColumn(insertValueToken, this.encryptRule.findAssistedQueryEncryptor(tableName, columnName).get(), columnIndex, encryptContext, insertValueContext, originalValue);
            }
            this.setCipherColumn(insertValueToken, encryptor.get(), columnIndex, encryptContext, (ExpressionSegment)insertValueContext.getValueExpressions().get(columnIndex), originalValue);
        }
    }

    private void addPlainColumn(InsertValue insertValueToken, int columnIndex, EncryptContext encryptContext, InsertValueContext insertValueContext, Object originalValue) {
        if (this.encryptRule.findPlainColumn(encryptContext.getTableName(), encryptContext.getColumnName()).isPresent()) {
            DerivedLiteralExpressionSegment derivedExpressionSegment = this.isAddLiteralExpressionSegment(insertValueContext, columnIndex) ? new DerivedLiteralExpressionSegment(originalValue) : new DerivedParameterMarkerExpressionSegment(this.getParameterIndexCount(insertValueToken));
            insertValueToken.getValues().add(columnIndex + 1, derivedExpressionSegment);
        }
    }

    private void addAssistedQueryColumn(InsertValue insertValueToken, EncryptAlgorithm encryptAlgorithm, int columnIndex, EncryptContext encryptContext, InsertValueContext insertValueContext, Object originalValue) {
        if (this.encryptRule.findAssistedQueryColumn(encryptContext.getTableName(), encryptContext.getColumnName()).isPresent()) {
            DerivedLiteralExpressionSegment derivedExpressionSegment = this.isAddLiteralExpressionSegment(insertValueContext, columnIndex) ? new DerivedLiteralExpressionSegment(encryptAlgorithm.encrypt(originalValue, encryptContext)) : new DerivedParameterMarkerExpressionSegment(this.getParameterIndexCount(insertValueToken));
            insertValueToken.getValues().add(columnIndex + 1, derivedExpressionSegment);
        }
    }

    private boolean isAddLiteralExpressionSegment(InsertValueContext insertValueContext, int columnIndex) {
        return insertValueContext.getParameters().isEmpty() || insertValueContext.getValueExpressions().get(columnIndex) instanceof LiteralExpressionSegment;
    }

    private int getParameterIndexCount(InsertValue insertValueToken) {
        int result = 0;
        for (ExpressionSegment each : insertValueToken.getValues()) {
            if (!(each instanceof ParameterMarkerExpressionSegment)) continue;
            ++result;
        }
        return result;
    }

    private void setCipherColumn(InsertValue insertValueToken, EncryptAlgorithm encryptAlgorithm, int columnIndex, EncryptContext encryptContext, ExpressionSegment valueExpression, Object originalValue) {
        if (valueExpression instanceof LiteralExpressionSegment) {
            insertValueToken.getValues().set(columnIndex, new LiteralExpressionSegment(valueExpression.getStartIndex(), valueExpression.getStopIndex(), encryptAlgorithm.encrypt(originalValue, encryptContext)));
        }
    }

    @Generated
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

