/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.constant.SubqueryType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class EncryptProjectionTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext<?>>,
PreviousSQLTokensAware,
SchemaMetaDataAware,
EncryptRuleAware {
    private List<SQLToken> previousSQLTokens;
    private EncryptRule encryptRule;
    private String databaseName;
    private Map<String, ShardingSphereSchema> schemas;

    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !((SelectStatementContext)sqlStatementContext).getAllTables().isEmpty();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext<?> sqlStatementContext) {
        Preconditions.checkState((boolean)(sqlStatementContext instanceof SelectStatementContext));
        LinkedHashSet<SubstitutableColumnNameToken> result = new LinkedHashSet<SubstitutableColumnNameToken>();
        SelectStatementContext selectStatementContext = (SelectStatementContext)sqlStatementContext;
        this.addGenerateSQLTokens(result, selectStatementContext);
        for (SelectStatementContext each : selectStatementContext.getSubqueryContexts().values()) {
            this.addGenerateSQLTokens(result, each);
        }
        return result;
    }

    private void addGenerateSQLTokens(Collection<SubstitutableColumnNameToken> result, SelectStatementContext selectStatementContext) {
        Map<String, String> columnTableNames = this.getColumnTableNames(selectStatementContext);
        for (ProjectionSegment projection : ((SelectStatement)selectStatementContext.getSqlStatement()).getProjections().getProjections()) {
            ShorthandProjectionSegment shorthandSegment;
            Collection<ColumnProjection> actualColumns;
            ColumnProjectionSegment columnSegment;
            ColumnProjection columnProjection;
            String tableName;
            SubqueryType subqueryType = selectStatementContext.getSubqueryType();
            if (projection instanceof ColumnProjectionSegment && null != (tableName = columnTableNames.get((columnProjection = this.buildColumnProjection(columnSegment = (ColumnProjectionSegment)projection)).getExpression())) && this.encryptRule.findEncryptColumn(tableName, columnProjection.getName()).isPresent()) {
                result.add(this.generateSQLToken(tableName, columnSegment, columnProjection, subqueryType));
            }
            if (!(projection instanceof ShorthandProjectionSegment) || (actualColumns = this.getShorthandProjection(shorthandSegment = (ShorthandProjectionSegment)projection, selectStatementContext.getProjectionsContext()).getActualColumns().values()).isEmpty()) continue;
            result.add(this.generateSQLToken(shorthandSegment, actualColumns, selectStatementContext.getDatabaseType(), subqueryType, columnTableNames));
        }
    }

    private SubstitutableColumnNameToken generateSQLToken(String tableName, ColumnProjectionSegment columnSegment, ColumnProjection columnProjection, SubqueryType subqueryType) {
        Collection<ColumnProjection> projections = this.generateProjections(tableName, columnProjection, subqueryType, false, null);
        int startIndex = columnSegment.getColumn().getOwner().isPresent() ? ((OwnerSegment)columnSegment.getColumn().getOwner().get()).getStopIndex() + 2 : columnSegment.getColumn().getStartIndex();
        int stopIndex = columnSegment.getStopIndex();
        return new SubstitutableColumnNameToken(startIndex, stopIndex, projections);
    }

    private SubstitutableColumnNameToken generateSQLToken(ShorthandProjectionSegment segment, Collection<ColumnProjection> actualColumns, DatabaseType databaseType, SubqueryType subqueryType, Map<String, String> columnTableNames) {
        LinkedList<ColumnProjection> projections = new LinkedList<ColumnProjection>();
        for (ColumnProjection each2 : actualColumns) {
            String tableName = columnTableNames.get(each2.getExpression());
            if (null == tableName || !this.encryptRule.findEncryptor(tableName, each2.getName()).isPresent()) {
                projections.add(new ColumnProjection(each2.getOwner(), each2.getName(), (String)each2.getAlias().orElse(null)));
                continue;
            }
            projections.addAll(this.generateProjections(tableName, each2, subqueryType, true, segment));
        }
        int startIndex = segment.getOwner().isPresent() ? ((OwnerSegment)segment.getOwner().get()).getStartIndex() : segment.getStartIndex();
        this.previousSQLTokens.removeIf(each -> each.getStartIndex() == startIndex);
        return new SubstitutableColumnNameToken(startIndex, segment.getStopIndex(), projections, databaseType.getQuoteCharacter());
    }

    private ColumnProjection buildColumnProjection(ColumnProjectionSegment segment) {
        String owner = segment.getColumn().getOwner().map(optional -> optional.getIdentifier().getValue()).orElse(null);
        return new ColumnProjection(owner, segment.getColumn().getIdentifier().getValue(), (String)segment.getAlias().orElse(null));
    }

    private Map<String, String> getColumnTableNames(SelectStatementContext selectStatementContext) {
        LinkedList<Object> columns = new LinkedList<Object>();
        for (Projection projection : selectStatementContext.getProjectionsContext().getProjections()) {
            if (projection instanceof ColumnProjection) {
                columns.add((ColumnProjection)projection);
            }
            if (!(projection instanceof ShorthandProjection)) continue;
            columns.addAll(((ShorthandProjection)projection).getActualColumns().values());
        }
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)selectStatementContext.getDatabaseType(), (String)this.databaseName);
        ShardingSphereSchema schema = selectStatementContext.getTablesContext().getSchemaName().map(this.schemas::get).orElseGet(() -> this.schemas.get(defaultSchema));
        return selectStatementContext.getTablesContext().findTableNamesByColumnProjection(columns, schema);
    }

    private Collection<ColumnProjection> generateProjections(String tableName, ColumnProjection column, SubqueryType subqueryType, boolean shorthand, ShorthandProjectionSegment segment) {
        LinkedList<ColumnProjection> result = new LinkedList<ColumnProjection>();
        if (SubqueryType.PREDICATE_SUBQUERY.equals((Object)subqueryType)) {
            result.add(this.distinctOwner(this.generatePredicateSubqueryProjection(tableName, column), shorthand));
        } else if (SubqueryType.TABLE_SUBQUERY.equals((Object)subqueryType)) {
            result.addAll(this.generateTableSubqueryProjections(tableName, column, shorthand));
        } else if (SubqueryType.EXISTS_SUBQUERY.equals((Object)subqueryType)) {
            result.addAll(this.generateExistsSubqueryProjections(tableName, column, shorthand));
        } else {
            result.add(this.distinctOwner(this.generateCommonProjection(tableName, column, segment), shorthand));
        }
        return result;
    }

    private ColumnProjection distinctOwner(ColumnProjection column, boolean shorthand) {
        if (shorthand || null == column.getOwner()) {
            return column;
        }
        return new ColumnProjection(null, column.getName(), column.getAlias().isPresent() ? (String)column.getAlias().get() : null);
    }

    private ColumnProjection generatePredicateSubqueryProjection(String tableName, ColumnProjection column) {
        Optional<String> plainColumn;
        boolean queryWithCipherColumn = this.encryptRule.isQueryWithCipherColumn(tableName, column.getName());
        if (!queryWithCipherColumn && (plainColumn = this.encryptRule.findPlainColumn(tableName, column.getName())).isPresent()) {
            return new ColumnProjection(column.getOwner(), plainColumn.get(), null);
        }
        Optional<String> assistedQueryColumn = this.encryptRule.findAssistedQueryColumn(tableName, column.getName());
        if (assistedQueryColumn.isPresent()) {
            return new ColumnProjection(column.getOwner(), assistedQueryColumn.get(), null);
        }
        String cipherColumn = this.encryptRule.getCipherColumn(tableName, column.getName());
        return new ColumnProjection(column.getOwner(), cipherColumn, null);
    }

    private Collection<ColumnProjection> generateTableSubqueryProjections(String tableName, ColumnProjection column, boolean shorthand) {
        LinkedList<ColumnProjection> result = new LinkedList<ColumnProjection>();
        result.add(this.distinctOwner(new ColumnProjection(column.getOwner(), this.encryptRule.getCipherColumn(tableName, column.getName()), null), shorthand));
        Optional<String> assistedQueryColumn = this.encryptRule.findAssistedQueryColumn(tableName, column.getName());
        assistedQueryColumn.ifPresent(optional -> result.add(new ColumnProjection(column.getOwner(), optional, null)));
        Optional<String> plainColumn = this.encryptRule.findPlainColumn(tableName, column.getName());
        plainColumn.ifPresent(optional -> result.add(new ColumnProjection(column.getOwner(), optional, null)));
        return result;
    }

    private Collection<ColumnProjection> generateExistsSubqueryProjections(String tableName, ColumnProjection column, boolean shorthand) {
        LinkedList<ColumnProjection> result = new LinkedList<ColumnProjection>();
        result.add(this.distinctOwner(new ColumnProjection(column.getOwner(), this.encryptRule.getCipherColumn(tableName, column.getName()), null), shorthand));
        return result;
    }

    private ColumnProjection generateCommonProjection(String tableName, ColumnProjection column, ShorthandProjectionSegment segment) {
        String encryptColumnName = this.getEncryptColumnName(tableName, column.getName());
        String owner = null == segment || !segment.getOwner().isPresent() ? column.getOwner() : ((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue();
        return new ColumnProjection(owner, encryptColumnName, column.getAlias().orElse(column.getName()));
    }

    private String getEncryptColumnName(String tableName, String logicEncryptColumnName) {
        boolean queryWithCipherColumn = this.encryptRule.isQueryWithCipherColumn(tableName, logicEncryptColumnName);
        if (queryWithCipherColumn) {
            return this.encryptRule.getCipherColumn(tableName, logicEncryptColumnName);
        }
        return this.encryptRule.findPlainColumn(tableName, logicEncryptColumnName).orElseGet(() -> this.encryptRule.getCipherColumn(tableName, logicEncryptColumnName));
    }

    private ShorthandProjection getShorthandProjection(ShorthandProjectionSegment segment, ProjectionsContext projectionsContext) {
        Optional owner = segment.getOwner().isPresent() ? Optional.of(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue()) : Optional.empty();
        for (Projection each : projectionsContext.getProjections()) {
            if (!(each instanceof ShorthandProjection)) continue;
            if (!owner.isPresent() && !((ShorthandProjection)each).getOwner().isPresent()) {
                return (ShorthandProjection)each;
            }
            if (!owner.isPresent() || !((String)owner.get()).equals(((ShorthandProjection)each).getOwner().orElse(null))) continue;
            return (ShorthandProjection)each;
        }
        throw new IllegalStateException(String.format("Can not find shorthand projection segment, owner is `%s`", owner.orElse(null)));
    }

    @Generated
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setSchemas(Map<String, ShardingSphereSchema> schemas) {
        this.schemas = schemas;
    }
}

