/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptLogicColumnNotFoundException;
import org.apache.shardingsphere.encrypt.rule.EncryptColumn;

public final class EncryptTable {
    private final Map<String, EncryptColumn> columns = new TreeMap<String, EncryptColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Boolean queryWithCipherColumn;

    public EncryptTable(EncryptTableRuleConfiguration config) {
        for (EncryptColumnRuleConfiguration each : config.getColumns()) {
            this.columns.put(each.getLogicColumn(), new EncryptColumn(each.getCipherColumn(), each.getAssistedQueryColumn(), each.getPlainColumn(), each.getEncryptorName(), each.getAssistedQueryEncryptorName(), each.getQueryWithCipherColumn()));
        }
        this.queryWithCipherColumn = config.getQueryWithCipherColumn();
    }

    public Optional<String> findEncryptorName(String logicColumn) {
        return this.columns.containsKey(logicColumn) ? Optional.of(this.columns.get(logicColumn).getEncryptorName()) : Optional.empty();
    }

    public Optional<String> findAssistedQueryEncryptorName(String logicColumn) {
        return this.columns.containsKey(logicColumn) ? Optional.ofNullable(this.columns.get(logicColumn).getAssistedQueryEncryptorName()) : Optional.empty();
    }

    public Collection<String> getLogicColumns() {
        return this.columns.keySet();
    }

    public String getLogicColumnByCipherColumn(String cipherColumn) {
        for (Map.Entry<String, EncryptColumn> entry : this.columns.entrySet()) {
            if (!entry.getValue().getCipherColumn().equals(cipherColumn)) continue;
            return entry.getKey();
        }
        throw new EncryptLogicColumnNotFoundException(cipherColumn);
    }

    public String getLogicColumnByPlainColumn(String plainColumn) {
        for (Map.Entry<String, EncryptColumn> entry : this.columns.entrySet()) {
            if (!entry.getValue().getPlainColumn().isPresent() || !entry.getValue().getPlainColumn().get().equals(plainColumn)) continue;
            return entry.getKey();
        }
        throw new EncryptLogicColumnNotFoundException(plainColumn);
    }

    public boolean isCipherColumn(String columnName) {
        return this.columns.values().stream().anyMatch(each -> each.getCipherColumn().equalsIgnoreCase(columnName));
    }

    public String getCipherColumn(String logicColumn) {
        return this.columns.get(logicColumn).getCipherColumn();
    }

    public Collection<String> getAssistedQueryColumns() {
        LinkedList<String> result = new LinkedList<String>();
        for (EncryptColumn each : this.columns.values()) {
            if (!each.getAssistedQueryColumn().isPresent()) continue;
            result.add(each.getAssistedQueryColumn().get());
        }
        return result;
    }

    public Optional<String> findAssistedQueryColumn(String logicColumn) {
        return this.columns.containsKey(logicColumn) ? this.columns.get(logicColumn).getAssistedQueryColumn() : Optional.empty();
    }

    public Collection<String> getPlainColumns() {
        LinkedList<String> result = new LinkedList<String>();
        for (EncryptColumn each : this.columns.values()) {
            if (!each.getPlainColumn().isPresent()) continue;
            result.add(each.getPlainColumn().get());
        }
        return result;
    }

    public Optional<String> findPlainColumn(String logicColumn) {
        return this.columns.containsKey(logicColumn) ? this.columns.get(logicColumn).getPlainColumn() : Optional.empty();
    }

    public Map<String, String> getLogicAndCipherColumns() {
        HashMap<String, String> result = new HashMap<String, String>(this.columns.size(), 1.0f);
        for (Map.Entry<String, EncryptColumn> entry : this.columns.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getCipherColumn());
        }
        return result;
    }

    public Optional<Boolean> getQueryWithCipherColumn(String logicColumn) {
        return Optional.ofNullable(this.findEncryptColumn(logicColumn).map(EncryptColumn::getQueryWithCipherColumn).orElse(this.queryWithCipherColumn));
    }

    public Optional<EncryptColumn> findEncryptColumn(String logicColumn) {
        return Optional.ofNullable(this.columns.get(logicColumn));
    }
}

