/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.yaml.swapper;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.encrypt.algorithm.config.AlgorithmProvidedEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.rule.YamlEncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.rule.YamlEncryptTableRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;

public final class YamlEncryptRuleAlgorithmProviderConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlEncryptRuleConfiguration, AlgorithmProvidedEncryptRuleConfiguration> {
    private final YamlEncryptTableRuleConfigurationSwapper tableSwapper = new YamlEncryptTableRuleConfigurationSwapper();

    public YamlEncryptRuleConfiguration swapToYamlConfiguration(AlgorithmProvidedEncryptRuleConfiguration data) {
        YamlEncryptRuleConfiguration result = new YamlEncryptRuleConfiguration();
        data.getTables().forEach(each -> result.getTables().put(each.getName(), this.tableSwapper.swapToYamlConfiguration((EncryptTableRuleConfiguration)each)));
        data.getEncryptors().forEach((key, value) -> result.getEncryptors().put((String)key, new YamlAlgorithmConfiguration(value.getType(), value.getProps())));
        result.setQueryWithCipherColumn(data.isQueryWithCipherColumn());
        return result;
    }

    public AlgorithmProvidedEncryptRuleConfiguration swapToObject(YamlEncryptRuleConfiguration yamlConfig) {
        AlgorithmProvidedEncryptRuleConfiguration result = new AlgorithmProvidedEncryptRuleConfiguration();
        result.setTables(this.swapTables(yamlConfig));
        result.setQueryWithCipherColumn(yamlConfig.isQueryWithCipherColumn());
        return result;
    }

    private Collection<EncryptTableRuleConfiguration> swapTables(YamlEncryptRuleConfiguration yamlConfig) {
        LinkedList<EncryptTableRuleConfiguration> result = new LinkedList<EncryptTableRuleConfiguration>();
        for (Map.Entry<String, YamlEncryptTableRuleConfiguration> entry : yamlConfig.getTables().entrySet()) {
            YamlEncryptTableRuleConfiguration yamlEncryptTableRuleConfig = entry.getValue();
            yamlEncryptTableRuleConfig.setName(entry.getKey());
            result.add(this.tableSwapper.swapToObject(yamlEncryptTableRuleConfig));
        }
        return result;
    }

    public Class<AlgorithmProvidedEncryptRuleConfiguration> getTypeClass() {
        return AlgorithmProvidedEncryptRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "ENCRYPT";
    }

    public int getOrder() {
        return 11;
    }
}

