/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.refresh.impl;

import java.util.Collection;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.refresh.MetaDataRefreshStrategy;
import org.apache.shardingsphere.infra.metadata.refresh.TableMetaDataLoaderCallback;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropViewStatement;

public final class DropViewStatementMetaDataRefreshStrategy
implements MetaDataRefreshStrategy<DropViewStatement> {
    @Override
    public void refreshMetaData(ShardingSphereMetaData metaData, DatabaseType databaseType, Collection<String> routeDataSourceNames, DropViewStatement sqlStatement, TableMetaDataLoaderCallback callback) {
        sqlStatement.getViews().forEach(each -> this.removeMetaData(metaData, each.getTableName().getIdentifier().getValue(), routeDataSourceNames));
    }

    private void removeMetaData(ShardingSphereMetaData metaData, String viewName, Collection<String> routeDataSourceNames) {
        for (String each : routeDataSourceNames) {
            Collection<String> schemaMetaData = metaData.getSchemaMetaData().getUnconfiguredSchemaMetaDataMap().get(each);
            if (null == schemaMetaData) continue;
            schemaMetaData.remove(viewName);
        }
        metaData.getSchemaMetaData().getSchemaMetaData().remove(viewName);
    }
}

