/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SystemSchemaBuilderRule;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlTableMetaData;
import org.apache.shardingsphere.infra.yaml.schema.swapper.TableMetaDataYamlSwapper;
import org.yaml.snakeyaml.Yaml;

public final class SystemSchemaBuilder {
    public static Map<String, ShardingSphereSchema> build(String databaseName, DatabaseType databaseType) {
        LinkedHashMap<String, ShardingSphereSchema> result = new LinkedHashMap<String, ShardingSphereSchema>(databaseType.getSystemSchemas().size(), 1.0f);
        TableMetaDataYamlSwapper swapper = new TableMetaDataYamlSwapper();
        for (String each : SystemSchemaBuilder.getSystemSchemas(databaseName, databaseType)) {
            Collection<InputStream> schemaStreams = SystemSchemaBuilder.getSchemaStreams(each, databaseType);
            if (schemaStreams.isEmpty()) continue;
            result.put(each, SystemSchemaBuilder.createSchema(schemaStreams, swapper));
        }
        return result;
    }

    private static Collection<String> getSystemSchemas(String originalDatabaseName, DatabaseType databaseType) {
        String databaseName = databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType ? "postgres" : originalDatabaseName;
        return databaseType.getSystemDatabaseSchemaMap().getOrDefault(databaseName, Collections.emptyList());
    }

    private static Collection<InputStream> getSchemaStreams(String schemaName, DatabaseType databaseType) {
        SystemSchemaBuilderRule builderRule = SystemSchemaBuilderRule.valueOf(databaseType.getName(), schemaName);
        LinkedList<InputStream> result = new LinkedList<InputStream>();
        for (String each : builderRule.getTables()) {
            result.add(SystemSchemaBuilder.class.getClassLoader().getResourceAsStream("schema/" + databaseType.getName().toLowerCase() + "/" + schemaName + "/" + each + ".yaml"));
        }
        return result;
    }

    private static ShardingSphereSchema createSchema(Collection<InputStream> schemaStreams, TableMetaDataYamlSwapper swapper) {
        LinkedHashMap<String, TableMetaData> tables = new LinkedHashMap<String, TableMetaData>(schemaStreams.size(), 1.0f);
        for (InputStream each : schemaStreams) {
            YamlTableMetaData metaData = (YamlTableMetaData)new Yaml().loadAs(each, YamlTableMetaData.class);
            tables.put(metaData.getName(), swapper.swapToObject(metaData));
        }
        return new ShardingSphereSchema(tables);
    }

    @Generated
    private SystemSchemaBuilder() {
    }
}

