/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.loader.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.loader.adapter.MetaDataLoaderConnectionAdapter;

public final class SchemaMetaDataLoader {
    private static final String TABLE_TYPE = "TABLE";
    private static final String VIEW_TYPE = "VIEW";
    private static final String TABLE_NAME = "TABLE_NAME";

    public static Collection<String> loadAllTableNames(DatabaseType databaseType, DataSource dataSource) throws SQLException {
        try (MetaDataLoaderConnectionAdapter connectionAdapter = new MetaDataLoaderConnectionAdapter(databaseType, dataSource.getConnection());){
            Collection<String> collection = SchemaMetaDataLoader.loadAllTableNames(connectionAdapter);
            return collection;
        }
    }

    private static Collection<String> loadAllTableNames(Connection connection) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), null, new String[]{TABLE_TYPE, VIEW_TYPE});){
            while (resultSet.next()) {
                String table = resultSet.getString(TABLE_NAME);
                if (SchemaMetaDataLoader.isSystemTable(table)) continue;
                result.add(table);
            }
        }
        return result;
    }

    private static boolean isSystemTable(String table) {
        return table.contains("$") || table.contains("/");
    }

    @Generated
    private SchemaMetaDataLoader() {
    }
}

