/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core;

import java.rmi.server.UID;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Savepoint;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;

public final class ShardingSphereSavepoint
implements Savepoint {
    private final String savepointName;

    public ShardingSphereSavepoint() {
        this.savepointName = ShardingSphereSavepoint.getUniqueId();
    }

    public ShardingSphereSavepoint(String name) throws SQLException {
        ShardingSpherePreconditions.checkState((null != name && 0 != name.length() ? 1 : 0) != 0, () -> new SQLFeatureNotSupportedException("Savepoint name can not be NULL or empty"));
        this.savepointName = name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        throw new SQLFeatureNotSupportedException("Only named savepoint are supported.");
    }

    @Override
    public String getSavepointName() {
        return this.savepointName;
    }

    private static String getUniqueId() {
        String uidStr = new UID().toString();
        int uidLength = uidStr.length();
        StringBuilder safeString = new StringBuilder(uidLength + 1);
        safeString.append('_');
        for (int i = 0; i < uidLength; ++i) {
            char c = uidStr.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                safeString.append(c);
                continue;
            }
            safeString.append('_');
        }
        return safeString.toString();
    }
}

