/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractDataSourceAdapter;
import org.apache.shardingsphere.driver.jdbc.context.JDBCContext;
import org.apache.shardingsphere.driver.state.DriverStateContext;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.scope.GlobalRuleConfiguration;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataBuilderFactory;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderFactory;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;

public final class ShardingSphereDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private final String databaseName;
    private final ContextManager contextManager;
    private final JDBCContext jdbcContext;

    public ShardingSphereDataSource(String databaseName, ModeConfiguration modeConfig) throws SQLException {
        this.databaseName = databaseName;
        this.contextManager = this.createContextManager(databaseName, modeConfig, new HashMap<String, DataSource>(), new LinkedList<RuleConfiguration>(), new Properties());
        this.jdbcContext = new JDBCContext(this.contextManager.getDataSourceMap(databaseName));
    }

    public ShardingSphereDataSource(String databaseName, ModeConfiguration modeConfig, Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> ruleConfigs, Properties props) throws SQLException {
        this.databaseName = databaseName;
        this.contextManager = this.createContextManager(databaseName, modeConfig, dataSourceMap, ruleConfigs, null == props ? new Properties() : props);
        this.jdbcContext = new JDBCContext(this.contextManager.getDataSourceMap(databaseName));
    }

    private ContextManager createContextManager(String databaseName, ModeConfiguration modeConfig, Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> ruleConfigs, Properties props) throws SQLException {
        InstanceMetaData instanceMetaData = InstanceMetaDataBuilderFactory.create((String)"JDBC", (int)-1);
        Collection globalRuleConfigs = ruleConfigs.stream().filter(each -> each instanceof GlobalRuleConfiguration).collect(Collectors.toList());
        LinkedList<RuleConfiguration> databaseRuleConfigs = new LinkedList<RuleConfiguration>(ruleConfigs);
        databaseRuleConfigs.removeAll(globalRuleConfigs);
        ContextManagerBuilderParameter parameter = new ContextManagerBuilderParameter(modeConfig, Collections.singletonMap(databaseName, new DataSourceProvidedDatabaseConfiguration(dataSourceMap, databaseRuleConfigs)), globalRuleConfigs, props, Collections.emptyList(), instanceMetaData, false);
        return ContextManagerBuilderFactory.getInstance((ModeConfiguration)modeConfig).build(parameter);
    }

    @Override
    public Connection getConnection() {
        return DriverStateContext.getConnection(this.databaseName, this.contextManager, this.jdbcContext);
    }

    @Override
    public Connection getConnection(String username, String password) {
        return this.getConnection();
    }

    public void close(Collection<String> dataSourceNames) throws Exception {
        Map dataSourceMap = this.contextManager.getDataSourceMap(this.databaseName);
        for (String each : dataSourceNames) {
            this.close((DataSource)dataSourceMap.get(each));
        }
        this.contextManager.close();
    }

    private void close(DataSource dataSource) throws Exception {
        if (dataSource instanceof AutoCloseable) {
            ((AutoCloseable)((Object)dataSource)).close();
        }
    }

    @Override
    public void close() throws Exception {
        this.close(this.contextManager.getDataSourceMap(this.databaseName).keySet());
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        Map dataSourceMap = this.contextManager.getDataSourceMap(this.databaseName);
        return dataSourceMap.isEmpty() ? 0 : ((DataSource)dataSourceMap.values().iterator().next()).getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        for (DataSource each : this.contextManager.getDataSourceMap(this.databaseName).values()) {
            each.setLoginTimeout(seconds);
        }
    }
}

