/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.datasource.metadata;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.driver.jdbc.adapter.AdaptedDatabaseMetaData;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.DatabaseMetaDataResultSet;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;

public final class ShardingSphereDatabaseMetaData
extends AdaptedDatabaseMetaData {
    private final ShardingSphereConnection connection;
    private final Collection<ShardingSphereRule> rules;
    private String currentPhysicalDataSourceName;
    private Connection currentPhysicalConnection;
    private DatabaseMetaData currentDatabaseMetaData;

    public ShardingSphereDatabaseMetaData(ShardingSphereConnection connection) {
        super(connection.getJdbcContext().getCachedDatabaseMetaData());
        this.connection = connection;
        this.rules = connection.getContextManager().getMetaDataContexts().getMetaData().getDatabase(connection.getDatabaseName()).getRuleMetaData().getRules();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (null == this.currentPhysicalConnection) {
            this.currentPhysicalConnection = this.connection.getConnectionManager().getRandomConnection();
        }
        return this.currentPhysicalConnection;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getSuperTypes(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), typeNamePattern));
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getSuperTables(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), this.getActualTableNamePattern(tableNamePattern)));
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getAttributes(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), typeNamePattern, attributeNamePattern));
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getProcedures(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), procedureNamePattern));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getProcedureColumns(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), procedureNamePattern, columnNamePattern));
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getTables(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), this.getActualTableNamePattern(tableNamePattern), types));
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getSchemas());
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getSchemas(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern)));
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getCatalogs());
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getTableTypes());
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getColumns(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), this.getActualTableNamePattern(tableNamePattern), columnNamePattern));
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getColumnPrivileges(this.getActualCatalog(catalog), this.getActualSchema(schema), this.getActualTable(this.getActualCatalog(catalog), table), columnNamePattern));
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getTablePrivileges(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), this.getActualTableNamePattern(tableNamePattern)));
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getBestRowIdentifier(this.getActualCatalog(catalog), this.getActualSchema(schema), this.getActualTable(this.getActualCatalog(catalog), table), scope, nullable));
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getVersionColumns(this.getActualCatalog(catalog), this.getActualSchema(schema), this.getActualTable(this.getActualCatalog(catalog), table)));
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getPrimaryKeys(this.getActualCatalog(catalog), this.getActualSchema(schema), this.getActualTable(this.getActualCatalog(catalog), table)));
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getImportedKeys(this.getActualCatalog(catalog), this.getActualSchema(schema), this.getActualTable(this.getActualCatalog(catalog), table)));
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getExportedKeys(this.getActualCatalog(catalog), this.getActualSchema(schema), this.getActualTable(this.getActualCatalog(catalog), table)));
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getCrossReference(this.getActualCatalog(parentCatalog), this.getActualSchema(parentSchema), parentTable, foreignCatalog, foreignSchema, foreignTable));
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getTypeInfo());
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getIndexInfo(this.getActualCatalog(catalog), this.getActualSchema(schema), this.getActualTable(this.getActualCatalog(catalog), table), unique, approximate));
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getUDTs(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), typeNamePattern, types));
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getClientInfoProperties());
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getFunctions(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), functionNamePattern));
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getFunctionColumns(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), functionNamePattern, columnNamePattern));
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.createDatabaseMetaDataResultSet(this.getDatabaseMetaData().getPseudoColumns(this.getActualCatalog(catalog), this.getActualSchema(schemaPattern), this.getActualTableNamePattern(tableNamePattern), columnNamePattern));
    }

    private String getActualTableNamePattern(String tableNamePattern) {
        return null == tableNamePattern ? null : this.findDataNodeContainedRule().filter(optional -> optional.findFirstActualTable(tableNamePattern).isPresent()).map(optional -> "%" + tableNamePattern + "%").orElse(tableNamePattern);
    }

    private String getActualTable(String catalog, String table) {
        return null == table ? null : this.findDataNodeContainedRule().map(each -> this.findActualTable((DataNodeContainedRule)each, catalog, table).orElse(table)).orElse(table);
    }

    private Optional<String> findActualTable(DataNodeContainedRule dataNodeContainedRule, String catalog, String table) {
        return Strings.isNullOrEmpty((String)catalog) ? dataNodeContainedRule.findFirstActualTable(table) : dataNodeContainedRule.findActualTableByCatalog(catalog, table);
    }

    private Optional<DataNodeContainedRule> findDataNodeContainedRule() {
        return this.rules.stream().filter(each -> each instanceof DataNodeContainedRule).findFirst().map(each -> (DataNodeContainedRule)each);
    }

    private ResultSet createDatabaseMetaDataResultSet(ResultSet resultSet) throws SQLException {
        return new DatabaseMetaDataResultSet(resultSet, this.rules);
    }

    private String getActualCatalog(String catalog) {
        DataSourceMetaData metaData = this.connection.getContextManager().getMetaDataContexts().getMetaData().getDatabase(this.connection.getDatabaseName()).getResourceMetaData().getDataSourceMetaData(this.getDataSourceName());
        return null != catalog && catalog.contains("logic_db") ? metaData.getCatalog() : catalog;
    }

    private String getActualSchema(String schema) {
        DataSourceMetaData metaData = this.connection.getContextManager().getMetaDataContexts().getMetaData().getDatabase(this.connection.getDatabaseName()).getResourceMetaData().getDataSourceMetaData(this.getDataSourceName());
        return null != schema && schema.contains("logic_db") ? metaData.getSchema() : schema;
    }

    private String getDataSourceName() {
        if (null == this.currentPhysicalDataSourceName) {
            this.currentPhysicalDataSourceName = this.connection.getConnectionManager().getRandomPhysicalDataSourceName();
        }
        return this.currentPhysicalDataSourceName;
    }

    private DatabaseMetaData getDatabaseMetaData() throws SQLException {
        if (null == this.currentDatabaseMetaData) {
            this.currentDatabaseMetaData = this.getConnection().getMetaData();
        }
        return this.currentDatabaseMetaData;
    }
}

