/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.shardingsphere.driver.api.yaml.YamlShardingSphereDataSourceFactory;
import org.apache.shardingsphere.driver.jdbc.core.driver.ShardingSphereDriverURL;

public final class DriverDataSourceCache {
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();

    public DataSource get(String url) {
        if (this.dataSourceMap.containsKey(url)) {
            return this.dataSourceMap.get(url);
        }
        return this.dataSourceMap.computeIfAbsent(url, DriverDataSourceCache::createDataSource);
    }

    private static <T extends Throwable> DataSource createDataSource(String url) throws T {
        try {
            return YamlShardingSphereDataSourceFactory.createDataSource(new ShardingSphereDriverURL(url).toConfigurationBytes());
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        catch (SQLException e) {
            throw e;
        }
    }
}

