/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.statement;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.adapter.executor.ForceExecuteTemplate;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;

public final class StatementManager
implements ExecutorJDBCStatementManager,
AutoCloseable {
    private final Map<CacheKey, Statement> cachedStatements = new ConcurrentHashMap<CacheKey, Statement>();
    private final ForceExecuteTemplate<Statement> forceExecuteTemplate = new ForceExecuteTemplate();

    public Statement createStorageResource(Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        return connection.createStatement(option.getResultSetType(), option.getResultSetConcurrency(), option.getResultSetHoldability());
    }

    public Statement createStorageResource(ExecutionUnit executionUnit, Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        Statement result = this.cachedStatements.get(new CacheKey(executionUnit, connectionMode));
        if (null == result) {
            String sql = executionUnit.getSqlUnit().getSql();
            result = option.isReturnGeneratedKeys() ? (null == option.getColumns() || 0 == option.getColumns().length ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql, option.getColumns())) : connection.prepareStatement(sql, option.getResultSetType(), option.getResultSetConcurrency(), option.getResultSetHoldability());
            this.cachedStatements.put(new CacheKey(executionUnit, connectionMode), result);
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.forceExecuteTemplate.execute(this.cachedStatements.values(), Statement::close);
        }
        finally {
            this.cachedStatements.clear();
        }
    }

    private static final class CacheKey {
        private final ExecutionUnit executionUnit;
        private final ConnectionMode connectionMode;

        @Generated
        public CacheKey(ExecutionUnit executionUnit, ConnectionMode connectionMode) {
            this.executionUnit = executionUnit;
            this.connectionMode = connectionMode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            ExecutionUnit this$executionUnit = this.executionUnit;
            ExecutionUnit other$executionUnit = other.executionUnit;
            if (this$executionUnit == null ? other$executionUnit != null : !this$executionUnit.equals(other$executionUnit)) {
                return false;
            }
            ConnectionMode this$connectionMode = this.connectionMode;
            ConnectionMode other$connectionMode = other.connectionMode;
            return !(this$connectionMode == null ? other$connectionMode != null : !this$connectionMode.equals(other$connectionMode));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExecutionUnit $executionUnit = this.executionUnit;
            result = result * 59 + ($executionUnit == null ? 43 : $executionUnit.hashCode());
            ConnectionMode $connectionMode = this.connectionMode;
            result = result * 59 + ($connectionMode == null ? 43 : $connectionMode.hashCode());
            return result;
        }
    }
}

