/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spring.boot;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.api.ShardingSphereDataSourceFactory;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.mode.YamlModeConfigurationSwapper;
import org.apache.shardingsphere.spring.boot.datasource.DataSourceMapSetter;
import org.apache.shardingsphere.spring.boot.prop.SpringBootPropertiesConfiguration;
import org.apache.shardingsphere.spring.boot.rule.LocalRulesCondition;
import org.apache.shardingsphere.spring.boot.schema.DatabaseNameSetter;
import org.apache.shardingsphere.spring.transaction.TransactionTypeScanner;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ComponentScan(value={"org.apache.shardingsphere.spring.boot.converter"})
@EnableConfigurationProperties(value={SpringBootPropertiesConfiguration.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class ShardingSphereAutoConfiguration
implements EnvironmentAware {
    private String databaseName;
    private final SpringBootPropertiesConfiguration props;
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();

    @Bean
    public ModeConfiguration modeConfiguration() {
        return null == this.props.getMode() ? null : new YamlModeConfigurationSwapper().swapToObject(this.props.getMode());
    }

    @Bean
    @Conditional(value={LocalRulesCondition.class})
    @Autowired(required=false)
    public DataSource shardingSphereDataSource(ObjectProvider<List<RuleConfiguration>> rules, ObjectProvider<ModeConfiguration> modeConfig) throws SQLException {
        Collection ruleConfigs = Optional.ofNullable(rules.getIfAvailable()).orElseGet(Collections::emptyList);
        return ShardingSphereDataSourceFactory.createDataSource((String)this.databaseName, (ModeConfiguration)((ModeConfiguration)modeConfig.getIfAvailable()), this.dataSourceMap, (Collection)ruleConfigs, (Properties)this.props.getProps());
    }

    @Bean
    @ConditionalOnMissingBean(value={DataSource.class})
    public DataSource dataSource(ModeConfiguration modeConfig) throws SQLException {
        return !this.dataSourceMap.isEmpty() ? ShardingSphereDataSourceFactory.createDataSource((String)this.databaseName, (ModeConfiguration)modeConfig, this.dataSourceMap, Collections.emptyList(), (Properties)this.props.getProps()) : ShardingSphereDataSourceFactory.createDataSource((String)this.databaseName, (ModeConfiguration)modeConfig);
    }

    @Bean
    public TransactionTypeScanner transactionTypeScanner() {
        return new TransactionTypeScanner();
    }

    public final void setEnvironment(Environment environment) {
        this.dataSourceMap.putAll(DataSourceMapSetter.getDataSourceMap((Environment)environment));
        this.databaseName = DatabaseNameSetter.getDatabaseName((Environment)environment);
    }

    @Generated
    public ShardingSphereAutoConfiguration(SpringBootPropertiesConfiguration props) {
        this.props = props;
    }
}

