/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabasesFactory;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.SchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereView;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.infra.rule.identifier.type.ResourceHeldRule;
import org.apache.shardingsphere.mode.manager.switcher.ResourceSwitchManager;
import org.apache.shardingsphere.mode.manager.switcher.SwitchingResource;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextManager.class);
    private volatile MetaDataContexts metaDataContexts;
    private final InstanceContext instanceContext;
    private final ExecutorEngine executorEngine;

    public ContextManager(MetaDataContexts metaDataContexts, InstanceContext instanceContext) {
        this.metaDataContexts = metaDataContexts;
        this.instanceContext = instanceContext;
        this.executorEngine = ExecutorEngine.createExecutorEngineWithSize((int)((Integer)metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.KERNEL_EXECUTOR_SIZE)));
    }

    public synchronized void renewMetaDataContexts(MetaDataContexts metaDataContexts) {
        this.metaDataContexts = metaDataContexts;
    }

    public Map<String, DataSource> getDataSourceMap(String databaseName) {
        return this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData().getDataSources();
    }

    public synchronized void addDatabase(String databaseName) {
        if (this.metaDataContexts.getMetaData().containsDatabase(databaseName)) {
            return;
        }
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(Collections.emptyMap(), (ConfigurationProperties)this.metaDataContexts.getMetaData().getProps());
        this.metaDataContexts.getMetaData().addDatabase(databaseName, protocolType);
    }

    public synchronized void addDatabaseAndPersist(String databaseName) {
        if (this.metaDataContexts.getMetaData().containsDatabase(databaseName)) {
            return;
        }
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(Collections.emptyMap(), (ConfigurationProperties)this.metaDataContexts.getMetaData().getProps());
        this.metaDataContexts.getMetaData().addDatabase(databaseName, protocolType);
        this.metaDataContexts.getPersistService().getDatabaseMetaDataService().addDatabase(databaseName);
    }

    public synchronized void dropDatabase(String databaseName) {
        if (!this.metaDataContexts.getMetaData().containsDatabase(databaseName)) {
            return;
        }
        String actualDatabaseName = this.metaDataContexts.getMetaData().getActualDatabaseName(databaseName);
        this.metaDataContexts.getMetaData().dropDatabase(actualDatabaseName);
    }

    public synchronized void dropDatabaseAndPersist(String databaseName) {
        if (!this.metaDataContexts.getMetaData().containsDatabase(databaseName)) {
            return;
        }
        String actualDatabaseName = this.metaDataContexts.getMetaData().getActualDatabaseName(databaseName);
        this.metaDataContexts.getMetaData().dropDatabase(actualDatabaseName);
        this.metaDataContexts.getPersistService().getDatabaseMetaDataService().dropDatabase(actualDatabaseName);
    }

    public synchronized void addSchema(String databaseName, String schemaName) {
        if (this.metaDataContexts.getMetaData().getDatabase(databaseName).containsSchema(schemaName)) {
            return;
        }
        this.metaDataContexts.getMetaData().getDatabase(databaseName).putSchema(schemaName, new ShardingSphereSchema());
    }

    public synchronized void alterSchema(String databaseName, String schemaName, String toBeDeletedTableName, String toBeDeletedViewName) {
        if (!this.metaDataContexts.getMetaData().containsDatabase(databaseName) || !this.metaDataContexts.getMetaData().getDatabase(databaseName).containsSchema(schemaName)) {
            return;
        }
        Optional.ofNullable(toBeDeletedTableName).ifPresent(optional -> this.dropTable(databaseName, schemaName, (String)optional));
        Optional.ofNullable(toBeDeletedViewName).ifPresent(optional -> this.dropView(databaseName, schemaName, (String)optional));
    }

    public synchronized void alterSchema(String databaseName, String schemaName, ShardingSphereTable toBeChangedTable, ShardingSphereView toBeChangedView) {
        if (!this.metaDataContexts.getMetaData().containsDatabase(databaseName) || !this.metaDataContexts.getMetaData().getDatabase(databaseName).containsSchema(schemaName)) {
            return;
        }
        Optional.ofNullable(toBeChangedTable).ifPresent(optional -> this.alterTable(databaseName, schemaName, (ShardingSphereTable)optional));
        Optional.ofNullable(toBeChangedView).ifPresent(optional -> this.alterView(databaseName, schemaName, (ShardingSphereView)optional));
    }

    private synchronized void dropTable(String databaseName, String schemaName, String toBeDeletedTableName) {
        this.metaDataContexts.getMetaData().getDatabase(databaseName).getSchema(schemaName).removeTable(toBeDeletedTableName);
        this.metaDataContexts.getMetaData().getDatabase(databaseName).getRuleMetaData().getRules().stream().filter(each -> each instanceof MutableDataNodeRule).findFirst().ifPresent(optional -> ((MutableDataNodeRule)optional).remove(schemaName, toBeDeletedTableName));
    }

    private synchronized void dropView(String databaseName, String schemaName, String toBeDeletedViewName) {
        this.metaDataContexts.getMetaData().getDatabase(databaseName).getSchema(schemaName).removeView(toBeDeletedViewName);
        this.metaDataContexts.getMetaData().getDatabase(databaseName).getRuleMetaData().getRules().stream().filter(each -> each instanceof MutableDataNodeRule).findFirst().ifPresent(optional -> ((MutableDataNodeRule)optional).remove(schemaName, toBeDeletedViewName));
    }

    private synchronized void alterTable(String databaseName, String schemaName, ShardingSphereTable beBoChangedTable) {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        if (!this.containsMutableDataNodeRule(database, beBoChangedTable.getName())) {
            database.reloadRules(MutableDataNodeRule.class);
        }
        database.getSchema(schemaName).putTable(beBoChangedTable.getName(), beBoChangedTable);
    }

    private synchronized void alterView(String databaseName, String schemaName, ShardingSphereView beBoChangedView) {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        if (!this.containsMutableDataNodeRule(database, beBoChangedView.getName())) {
            database.reloadRules(MutableDataNodeRule.class);
        }
        database.getSchema(schemaName).putView(beBoChangedView.getName(), beBoChangedView);
    }

    private boolean containsMutableDataNodeRule(ShardingSphereDatabase database, String tableName) {
        return database.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().filter(each -> !(each instanceof MutableDataNodeRule)).anyMatch(each -> each.getAllTables().contains(tableName));
    }

    public synchronized void dropSchema(String databaseName, String schemaName) {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        if (null == database || !database.containsSchema(schemaName)) {
            return;
        }
        database.removeSchema(schemaName);
    }

    public synchronized void addResources(String databaseName, Map<String, DataSourceProperties> toBeAddedDataSourcePropsMap) throws SQLException {
        SwitchingResource switchingResource = new ResourceSwitchManager().create(this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeAddedDataSourcePropsMap);
        this.metaDataContexts.getMetaData().getDatabases().putAll(this.createChangedDatabases(databaseName, switchingResource, null));
        this.metaDataContexts.getMetaData().getGlobalRuleMetaData().findRules(ResourceHeldRule.class).forEach(each -> each.addResource(this.metaDataContexts.getMetaData().getDatabase(databaseName)));
        this.metaDataContexts.getMetaData().getDatabase(databaseName).getSchemas().forEach((schemaName, schema) -> this.metaDataContexts.getPersistService().getDatabaseMetaDataService().persist(this.metaDataContexts.getMetaData().getActualDatabaseName(databaseName), (String)schemaName, (ShardingSphereSchema)schema));
        this.metaDataContexts.getPersistService().getDataSourceService().append(this.metaDataContexts.getMetaData().getActualDatabaseName(databaseName), toBeAddedDataSourcePropsMap);
        switchingResource.closeStaleDataSources();
    }

    public synchronized void updateResources(String databaseName, Map<String, DataSourceProperties> toBeUpdatedDataSourcePropsMap) throws SQLException {
        SwitchingResource switchingResource = new ResourceSwitchManager().create(this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeUpdatedDataSourcePropsMap);
        this.metaDataContexts.getMetaData().getDatabases().putAll(this.createChangedDatabases(databaseName, switchingResource, null));
        this.metaDataContexts.getMetaData().getGlobalRuleMetaData().findRules(ResourceHeldRule.class).forEach(each -> each.addResource(this.metaDataContexts.getMetaData().getDatabase(databaseName)));
        this.metaDataContexts.getMetaData().getDatabases().putAll(this.newShardingSphereDatabase(this.metaDataContexts.getMetaData().getDatabase(databaseName)));
        this.metaDataContexts.getPersistService().getDataSourceService().append(this.metaDataContexts.getMetaData().getActualDatabaseName(databaseName), toBeUpdatedDataSourcePropsMap);
        switchingResource.closeStaleDataSources();
    }

    public synchronized void dropResources(String databaseName, Collection<String> toBeDroppedResourceNames) throws SQLException {
        Object dataSourcePropsMap = this.metaDataContexts.getPersistService().getDataSourceService().load(this.metaDataContexts.getMetaData().getActualDatabaseName(databaseName));
        Map<String, DataSourceProperties> toBeDeletedDataSourcePropsMap = this.getToBeDeletedDataSourcePropsMap((Map<String, DataSourceProperties>)dataSourcePropsMap, toBeDroppedResourceNames);
        SwitchingResource switchingResource = new ResourceSwitchManager().createByDropResource(this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeDeletedDataSourcePropsMap);
        this.metaDataContexts.getMetaData().getDatabases().putAll(this.renewDatabase(this.metaDataContexts.getMetaData().getDatabase(databaseName), switchingResource));
        MetaDataContexts reloadMetaDataContexts = this.createMetaDataContexts(databaseName, switchingResource, null);
        this.alterSchemaMetaData(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), this.metaDataContexts.getMetaData().getDatabase(databaseName));
        this.deletedSchemaNames(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), this.metaDataContexts.getMetaData().getDatabase(databaseName));
        this.metaDataContexts = reloadMetaDataContexts;
        Map<String, DataSourceProperties> toBeReversedDataSourcePropsMap = this.getToBeReversedDataSourcePropsMap((Map<String, DataSourceProperties>)dataSourcePropsMap, toBeDroppedResourceNames);
        this.metaDataContexts.getPersistService().getDataSourceService().persist(this.metaDataContexts.getMetaData().getActualDatabaseName(databaseName), toBeReversedDataSourcePropsMap);
        switchingResource.closeStaleDataSources();
    }

    private Map<String, ShardingSphereDatabase> renewDatabase(ShardingSphereDatabase database, SwitchingResource resource) {
        LinkedHashMap<String, ShardingSphereDatabase> result = new LinkedHashMap<String, ShardingSphereDatabase>(1, 1.0f);
        Map<String, DataSource> newDataSource = database.getResourceMetaData().getDataSources().entrySet().stream().filter(entry -> !resource.getStaleDataSources().containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        result.put(database.getName().toLowerCase(), new ShardingSphereDatabase(database.getName(), database.getProtocolType(), new ShardingSphereResourceMetaData(database.getName(), newDataSource), database.getRuleMetaData(), database.getSchemas()));
        return result;
    }

    private Map<String, DataSourceProperties> getToBeDeletedDataSourcePropsMap(Map<String, DataSourceProperties> dataSourcePropsMap, Collection<String> toBeDroppedResourceNames) {
        return dataSourcePropsMap.entrySet().stream().filter(entry -> toBeDroppedResourceNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, DataSourceProperties> getToBeReversedDataSourcePropsMap(Map<String, DataSourceProperties> dataSourcePropsMap, Collection<String> toBeDroppedResourceNames) {
        return dataSourcePropsMap.entrySet().stream().filter(entry -> !toBeDroppedResourceNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private synchronized void alterSchemaMetaData(String databaseName, ShardingSphereDatabase reloadDatabase, ShardingSphereDatabase currentDatabase) {
        Map toBeDeletedTables = SchemaManager.getToBeDeletedTablesBySchemas((Map)reloadDatabase.getSchemas(), (Map)currentDatabase.getSchemas());
        Map toBeAddedTables = SchemaManager.getToBeAddedTablesBySchemas((Map)reloadDatabase.getSchemas(), (Map)currentDatabase.getSchemas());
        toBeAddedTables.forEach((key, value) -> this.metaDataContexts.getPersistService().getDatabaseMetaDataService().persist(databaseName, (String)key, (ShardingSphereSchema)value));
        toBeDeletedTables.forEach((key, value) -> this.metaDataContexts.getPersistService().getDatabaseMetaDataService().delete(databaseName, (String)key, (ShardingSphereSchema)value));
    }

    public synchronized void alterRuleConfiguration(String databaseName, Collection<RuleConfiguration> ruleConfigs) {
        try {
            Collection<ResourceHeldRule> staleResourceHeldRules = this.getStaleResourceHeldRules(databaseName);
            staleResourceHeldRules.forEach(ResourceHeldRule::closeStaleResource);
            MetaDataContexts reloadMetaDataContexts = this.createMetaDataContexts(databaseName, null, ruleConfigs);
            this.alterSchemaMetaData(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), this.metaDataContexts.getMetaData().getDatabase(databaseName));
            this.metaDataContexts = reloadMetaDataContexts;
            this.metaDataContexts.getMetaData().getDatabases().putAll(this.newShardingSphereDatabase(this.metaDataContexts.getMetaData().getDatabase(databaseName)));
        }
        catch (SQLException ex) {
            log.error("Alter database: {} rule configurations failed", (Object)databaseName, (Object)ex);
        }
    }

    public synchronized void alterDataSourceConfiguration(String databaseName, Map<String, DataSourceProperties> dataSourcePropsMap) {
        try {
            Collection<ResourceHeldRule> staleResourceHeldRules = this.getStaleResourceHeldRules(databaseName);
            staleResourceHeldRules.forEach(ResourceHeldRule::closeStaleResource);
            SwitchingResource switchingResource = new ResourceSwitchManager().create(this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), dataSourcePropsMap);
            this.metaDataContexts = this.createMetaDataContexts(databaseName, switchingResource, null);
            this.metaDataContexts.getMetaData().getDatabases().putAll(this.newShardingSphereDatabase(this.metaDataContexts.getMetaData().getDatabase(databaseName)));
            switchingResource.closeStaleDataSources();
        }
        catch (SQLException ex) {
            log.error("Alter database: {} data source configuration failed", (Object)databaseName, (Object)ex);
        }
    }

    public synchronized void alterDataSourceAndRuleConfiguration(String databaseName, Map<String, DataSourceProperties> dataSourcePropsMap, Collection<RuleConfiguration> ruleConfigs) {
        try {
            Collection<ResourceHeldRule> staleResourceHeldRules = this.getStaleResourceHeldRules(databaseName);
            staleResourceHeldRules.forEach(ResourceHeldRule::closeStaleResource);
            SwitchingResource switchingResource = new ResourceSwitchManager().create(this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), dataSourcePropsMap);
            this.metaDataContexts = this.createMetaDataContexts(databaseName, switchingResource, ruleConfigs);
            this.metaDataContexts.getMetaData().getDatabases().putAll(this.newShardingSphereDatabase(this.metaDataContexts.getMetaData().getDatabase(databaseName)));
            switchingResource.closeStaleDataSources();
        }
        catch (SQLException ex) {
            log.error("Alter database: {} data source and rule configuration failed", (Object)databaseName, (Object)ex);
        }
    }

    private Collection<ResourceHeldRule> getStaleResourceHeldRules(String databaseName) {
        LinkedList<ResourceHeldRule> result = new LinkedList<ResourceHeldRule>();
        result.addAll(this.metaDataContexts.getMetaData().getDatabase(databaseName).getRuleMetaData().findRules(ResourceHeldRule.class));
        result.addAll(this.metaDataContexts.getMetaData().getGlobalRuleMetaData().findRules(ResourceHeldRule.class));
        return result;
    }

    private MetaDataContexts createMetaDataContexts(String databaseName, SwitchingResource switchingResource, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        Map<String, ShardingSphereDatabase> changedDatabases = this.createChangedDatabases(databaseName, switchingResource, ruleConfigs);
        ConfigurationProperties props = this.metaDataContexts.getMetaData().getProps();
        ShardingSphereRuleMetaData changedGlobalMetaData = new ShardingSphereRuleMetaData(GlobalRulesBuilder.buildRules((Collection)this.metaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), changedDatabases, (InstanceContext)this.instanceContext, (ConfigurationProperties)props));
        return this.newMetaDataContexts(new ShardingSphereMetaData(changedDatabases, changedGlobalMetaData, props));
    }

    private Map<String, ShardingSphereDatabase> createChangedDatabases(String databaseName, SwitchingResource switchingResource, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        if (null != switchingResource && !switchingResource.getNewDataSources().isEmpty()) {
            this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData().getDataSources().putAll(switchingResource.getNewDataSources());
        }
        Collection toBeCreatedRuleConfigs = null == ruleConfigs ? this.metaDataContexts.getMetaData().getDatabase(databaseName).getRuleMetaData().getConfigurations() : ruleConfigs;
        DataSourceProvidedDatabaseConfiguration toBeCreatedDatabaseConfig = new DataSourceProvidedDatabaseConfiguration(this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData().getDataSources(), toBeCreatedRuleConfigs);
        ShardingSphereDatabase changedDatabase = ShardingSphereDatabasesFactory.create((String)this.metaDataContexts.getMetaData().getActualDatabaseName(databaseName), (DatabaseConfiguration)toBeCreatedDatabaseConfig, (ConfigurationProperties)this.metaDataContexts.getMetaData().getProps(), (InstanceContext)this.instanceContext);
        LinkedHashMap<String, ShardingSphereDatabase> result = new LinkedHashMap<String, ShardingSphereDatabase>(this.metaDataContexts.getMetaData().getDatabases());
        changedDatabase.getSchemas().putAll(this.newShardingSphereSchemas(changedDatabase));
        result.put(databaseName.toLowerCase(), changedDatabase);
        return result;
    }

    private MetaDataContexts newMetaDataContexts(ShardingSphereMetaData metaData) {
        return new MetaDataContexts(this.metaDataContexts.getPersistService(), metaData);
    }

    private Map<String, ShardingSphereSchema> newShardingSphereSchemas(ShardingSphereDatabase database) {
        LinkedHashMap<String, ShardingSphereSchema> result = new LinkedHashMap<String, ShardingSphereSchema>(database.getSchemas().size(), 1.0f);
        database.getSchemas().forEach((key, value) -> result.put((String)key, new ShardingSphereSchema(value.getTables(), (Map)this.metaDataContexts.getPersistService().getDatabaseMetaDataService().getViewMetaDataPersistService().load(database.getName(), (String)key))));
        return result;
    }

    private Map<String, ShardingSphereDatabase> newShardingSphereDatabase(ShardingSphereDatabase originalDatabase) {
        LinkedHashMap<String, ShardingSphereDatabase> result = new LinkedHashMap<String, ShardingSphereDatabase>(1, 1.0f);
        result.put(originalDatabase.getName().toLowerCase(), new ShardingSphereDatabase(originalDatabase.getName(), originalDatabase.getProtocolType(), originalDatabase.getResourceMetaData(), originalDatabase.getRuleMetaData(), this.metaDataContexts.getPersistService().getDatabaseMetaDataService().loadSchemas(originalDatabase.getName())));
        return result;
    }

    public synchronized void alterGlobalRuleConfiguration(Collection<RuleConfiguration> ruleConfigs) {
        if (ruleConfigs.isEmpty()) {
            return;
        }
        Collection staleResourceHeldRules = this.metaDataContexts.getMetaData().getGlobalRuleMetaData().findRules(ResourceHeldRule.class);
        staleResourceHeldRules.forEach(ResourceHeldRule::closeStaleResource);
        ShardingSphereRuleMetaData toBeChangedGlobalRuleMetaData = new ShardingSphereRuleMetaData(GlobalRulesBuilder.buildRules(ruleConfigs, (Map)this.metaDataContexts.getMetaData().getDatabases(), (InstanceContext)this.instanceContext, (ConfigurationProperties)this.metaDataContexts.getMetaData().getProps()));
        ShardingSphereMetaData toBeChangedMetaData = new ShardingSphereMetaData(this.metaDataContexts.getMetaData().getDatabases(), toBeChangedGlobalRuleMetaData, this.metaDataContexts.getMetaData().getProps());
        this.metaDataContexts = this.newMetaDataContexts(toBeChangedMetaData);
    }

    public synchronized void alterProperties(Properties props) {
        ShardingSphereMetaData toBeChangedMetaData = new ShardingSphereMetaData(this.metaDataContexts.getMetaData().getDatabases(), this.metaDataContexts.getMetaData().getGlobalRuleMetaData(), new ConfigurationProperties(props));
        this.metaDataContexts = this.newMetaDataContexts(toBeChangedMetaData);
    }

    public synchronized void reloadDatabase(String databaseName) {
        try {
            ShardingSphereResourceMetaData currentResourceMetaData = this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData();
            SwitchingResource switchingResource = new SwitchingResource(currentResourceMetaData, currentResourceMetaData.getDataSources(), Collections.emptyMap());
            MetaDataContexts reloadedMetaDataContexts = this.createMetaDataContexts(databaseName, switchingResource, null);
            this.deletedSchemaNames(databaseName, reloadedMetaDataContexts.getMetaData().getDatabase(databaseName), this.metaDataContexts.getMetaData().getDatabase(databaseName));
            this.metaDataContexts = reloadedMetaDataContexts;
            this.metaDataContexts.getMetaData().getDatabases().values().forEach(each -> each.getSchemas().forEach((schemaName, schema) -> this.metaDataContexts.getPersistService().getDatabaseMetaDataService().compareAndPersist(each.getName(), (String)schemaName, (ShardingSphereSchema)schema)));
        }
        catch (SQLException ex) {
            log.error("Reload database: {} failed", (Object)databaseName, (Object)ex);
        }
    }

    private void deletedSchemaNames(String databaseName, ShardingSphereDatabase reloadDatabase, ShardingSphereDatabase currentDatabase) {
        SchemaManager.getToBeDeletedSchemaNames((Map)reloadDatabase.getSchemas(), (Map)currentDatabase.getSchemas()).keySet().forEach(each -> this.metaDataContexts.getPersistService().getDatabaseMetaDataService().dropSchema(databaseName, (String)each));
    }

    public synchronized void reloadSchema(String databaseName, String schemaName, String dataSourceName) {
        try {
            ShardingSphereSchema reloadedSchema = this.loadSchema(databaseName, schemaName, dataSourceName);
            if (reloadedSchema.getTables().isEmpty()) {
                this.metaDataContexts.getMetaData().getDatabase(databaseName).removeSchema(schemaName);
                this.metaDataContexts.getPersistService().getDatabaseMetaDataService().dropSchema(this.metaDataContexts.getMetaData().getActualDatabaseName(databaseName), schemaName);
            } else {
                this.metaDataContexts.getMetaData().getDatabase(databaseName).putSchema(schemaName, reloadedSchema);
                this.metaDataContexts.getPersistService().getDatabaseMetaDataService().compareAndPersist(this.metaDataContexts.getMetaData().getActualDatabaseName(databaseName), schemaName, reloadedSchema);
            }
        }
        catch (SQLException ex) {
            log.error("Reload meta data of database: {} schema: {} with data source: {} failed", new Object[]{databaseName, schemaName, dataSourceName, ex});
        }
    }

    private ShardingSphereSchema loadSchema(String databaseName, String schemaName, String dataSourceName) throws SQLException {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        database.reloadRules(MutableDataNodeRule.class);
        GenericSchemaBuilderMaterials materials = new GenericSchemaBuilderMaterials(database.getProtocolType(), database.getResourceMetaData().getDatabaseType(), Collections.singletonMap(dataSourceName, database.getResourceMetaData().getDataSources().get(dataSourceName)), database.getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getProps(), schemaName);
        ShardingSphereSchema result = (ShardingSphereSchema)GenericSchemaBuilder.build((GenericSchemaBuilderMaterials)materials).get(schemaName);
        result.getViews().putAll(this.metaDataContexts.getPersistService().getDatabaseMetaDataService().getViewMetaDataPersistService().load(database.getName(), schemaName));
        return result;
    }

    public void reloadTable(String databaseName, String schemaName, String tableName) {
        Map dataSourceMap = this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData().getDataSources();
        try {
            this.reloadTable(databaseName, schemaName, tableName, dataSourceMap);
        }
        catch (SQLException ex) {
            log.error("Reload table: {} meta data of database: {} schema: {} failed", new Object[]{tableName, databaseName, schemaName, ex});
        }
    }

    public void reloadTable(String databaseName, String schemaName, String dataSourceName, String tableName) {
        Map<String, DataSource> dataSourceMap = Collections.singletonMap(dataSourceName, this.metaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData().getDataSources().get(dataSourceName));
        try {
            this.reloadTable(databaseName, schemaName, tableName, dataSourceMap);
        }
        catch (SQLException ex) {
            log.error("Reload table: {} meta data of database: {} schema: {} with data source: {} failed", new Object[]{tableName, databaseName, schemaName, dataSourceName, ex});
        }
    }

    private synchronized void reloadTable(String databaseName, String schemaName, String tableName, Map<String, DataSource> dataSourceMap) throws SQLException {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        GenericSchemaBuilderMaterials materials = new GenericSchemaBuilderMaterials(database.getProtocolType(), database.getResourceMetaData().getDatabaseType(), dataSourceMap, database.getRuleMetaData().getRules(), this.metaDataContexts.getMetaData().getProps(), schemaName);
        ShardingSphereSchema schema = GenericSchemaBuilder.build(Collections.singletonList(tableName), (GenericSchemaBuilderMaterials)materials).getOrDefault(schemaName, new ShardingSphereSchema());
        if (schema.containsTable(tableName)) {
            this.alterTable(databaseName, schemaName, schema.getTable(tableName));
        } else {
            this.dropTable(databaseName, schemaName, tableName);
        }
        this.metaDataContexts.getPersistService().getDatabaseMetaDataService().compareAndPersist(database.getName(), schemaName, database.getSchema(schemaName));
    }

    public synchronized void addShardingSphereDatabaseData(String databaseName) {
        if (this.metaDataContexts.getShardingSphereData().getDatabaseData().containsKey(databaseName)) {
            return;
        }
        this.metaDataContexts.getShardingSphereData().getDatabaseData().put(databaseName, new ShardingSphereDatabaseData());
    }

    public synchronized void dropShardingSphereDatabaseData(String databaseName) {
        if (!this.metaDataContexts.getShardingSphereData().getDatabaseData().containsKey(databaseName.toLowerCase())) {
            return;
        }
        this.metaDataContexts.getShardingSphereData().getDatabaseData().remove(databaseName);
    }

    public synchronized void addShardingSphereSchemaData(String databaseName, String schemaName) {
        if (((ShardingSphereDatabaseData)this.metaDataContexts.getShardingSphereData().getDatabaseData().get(databaseName)).getSchemaData().containsKey(schemaName)) {
            return;
        }
        ((ShardingSphereDatabaseData)this.metaDataContexts.getShardingSphereData().getDatabaseData().get(databaseName)).getSchemaData().put(schemaName, new ShardingSphereSchemaData());
    }

    public synchronized void dropShardingSphereSchemaData(String databaseName, String schemaName) {
        ShardingSphereDatabaseData databaseData = (ShardingSphereDatabaseData)this.metaDataContexts.getShardingSphereData().getDatabaseData().get(databaseName);
        if (null == databaseData || !databaseData.getSchemaData().containsKey(schemaName)) {
            return;
        }
        databaseData.getSchemaData().remove(schemaName);
    }

    public synchronized void alterSchemaData(String databaseName, String schemaName, String toBeDeletedTableName) {
        if (!this.metaDataContexts.getShardingSphereData().getDatabaseData().containsKey(databaseName) || !((ShardingSphereDatabaseData)this.metaDataContexts.getShardingSphereData().getDatabaseData().get(databaseName)).getSchemaData().containsKey(schemaName)) {
            return;
        }
        Optional.ofNullable(toBeDeletedTableName).ifPresent(optional -> this.dropTableData(databaseName, schemaName, (String)optional));
    }

    public synchronized void alterSchemaData(String databaseName, String schemaName, ShardingSphereTableData toBeChangedTable) {
        if (!this.metaDataContexts.getShardingSphereData().getDatabaseData().containsKey(databaseName) || !((ShardingSphereDatabaseData)this.metaDataContexts.getShardingSphereData().getDatabaseData().get(databaseName)).getSchemaData().containsKey(schemaName)) {
            return;
        }
        Optional.ofNullable(toBeChangedTable).ifPresent(optional -> this.alterTableData(databaseName, schemaName, (ShardingSphereTableData)optional));
    }

    private synchronized void alterTableData(String databaseName, String schemaName, ShardingSphereTableData toBeChangedTable) {
        ShardingSphereDatabaseData database = (ShardingSphereDatabaseData)this.metaDataContexts.getShardingSphereData().getDatabaseData().get(databaseName);
        ((ShardingSphereSchemaData)database.getSchemaData().get(schemaName)).getTableData().put(toBeChangedTable.getName(), toBeChangedTable);
    }

    private synchronized void dropTableData(String databaseName, String schemaName, String toBeDeletedTableName) {
        ((ShardingSphereSchemaData)((ShardingSphereDatabaseData)this.metaDataContexts.getShardingSphereData().getDatabaseData().get(databaseName)).getSchemaData().get(schemaName)).getTableData().remove(toBeDeletedTableName);
    }

    @Override
    public void close() {
        this.executorEngine.close();
        this.metaDataContexts.close();
    }

    @Generated
    public MetaDataContexts getMetaDataContexts() {
        return this.metaDataContexts;
    }

    @Generated
    public InstanceContext getInstanceContext() {
        return this.instanceContext;
    }

    @Generated
    public ExecutorEngine getExecutorEngine() {
        return this.executorEngine;
    }
}

