/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.switcher;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResourceMetaData;
import org.apache.shardingsphere.mode.manager.switcher.SwitchingResource;

public final class ResourceSwitchManager {
    public SwitchingResource create(ShardingSphereResourceMetaData resourceMetaData, Map<String, DataSourceProperties> toBeChangedDataSourceProps) {
        return new SwitchingResource(resourceMetaData, this.createNewDataSources(resourceMetaData, toBeChangedDataSourceProps), this.getStaleDataSources(resourceMetaData, toBeChangedDataSourceProps));
    }

    public SwitchingResource createByDropResource(ShardingSphereResourceMetaData resourceMetaData, Map<String, DataSourceProperties> toBeDeletedDataSourceProps) {
        return new SwitchingResource(resourceMetaData, Collections.emptyMap(), this.getStaleDataSources(resourceMetaData.getDataSources(), toBeDeletedDataSourceProps));
    }

    private Map<String, DataSource> createNewDataSources(ShardingSphereResourceMetaData resourceMetaData, Map<String, DataSourceProperties> toBeChangedDataSourceProps) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(resourceMetaData.getDataSources());
        result.keySet().removeAll(this.getToBeDeletedDataSources(resourceMetaData, toBeChangedDataSourceProps).keySet());
        result.putAll(this.createToBeChangedDataSources(resourceMetaData, toBeChangedDataSourceProps));
        result.putAll(this.createToBeAddedDataSources(resourceMetaData, toBeChangedDataSourceProps));
        return result;
    }

    private Map<String, DataSource> createToBeChangedDataSources(ShardingSphereResourceMetaData resourceMetaData, Map<String, DataSourceProperties> toBeChangedDataSourceProps) {
        return DataSourcePoolCreator.create(this.getChangedDataSourceProperties(resourceMetaData, toBeChangedDataSourceProps));
    }

    private Map<String, DataSourceProperties> getChangedDataSourceProperties(ShardingSphereResourceMetaData resourceMetaData, Map<String, DataSourceProperties> toBeChangedDataSourceProps) {
        return toBeChangedDataSourceProps.entrySet().stream().filter(entry -> this.isModifiedDataSource(resourceMetaData.getDataSources(), (String)entry.getKey(), (DataSourceProperties)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private boolean isModifiedDataSource(Map<String, DataSource> originalDataSources, String dataSourceName, DataSourceProperties dataSourceProps) {
        return originalDataSources.containsKey(dataSourceName) && !dataSourceProps.equals((Object)DataSourcePropertiesCreator.create((DataSource)originalDataSources.get(dataSourceName)));
    }

    private Map<String, DataSource> createToBeAddedDataSources(ShardingSphereResourceMetaData resourceMetaData, Map<String, DataSourceProperties> toBeChangedDataSourceProps) {
        Map<String, DataSourceProperties> toBeAddedDataSourceProps = toBeChangedDataSourceProps.entrySet().stream().filter(entry -> !resourceMetaData.getDataSources().containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return DataSourcePoolCreator.create(toBeAddedDataSourceProps);
    }

    private Map<String, DataSource> getStaleDataSources(ShardingSphereResourceMetaData resourceMetaData, Map<String, DataSourceProperties> toBeChangedDataSourceProps) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(resourceMetaData.getDataSources().size(), 1.0f);
        result.putAll(this.getToBeChangedDataSources(resourceMetaData, toBeChangedDataSourceProps));
        return result;
    }

    private Map<String, DataSource> getStaleDataSources(Map<String, DataSource> dataSources, Map<String, DataSourceProperties> toBeDeletedDataSourceProps) {
        return dataSources.entrySet().stream().filter(entry -> toBeDeletedDataSourceProps.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, DataSource> getToBeDeletedDataSources(ShardingSphereResourceMetaData resourceMetaData, Map<String, DataSourceProperties> toBeChangedDataSourceProps) {
        return resourceMetaData.getDataSources().entrySet().stream().filter(entry -> !toBeChangedDataSourceProps.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, DataSource> getToBeChangedDataSources(ShardingSphereResourceMetaData resourceMetaData, Map<String, DataSourceProperties> toBeChangedDataSourceProps) {
        Map<String, DataSourceProperties> changedDataSourceProps = this.getChangedDataSourceProperties(resourceMetaData, toBeChangedDataSourceProps);
        return resourceMetaData.getDataSources().entrySet().stream().filter(entry -> changedDataSourceProps.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

