/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereData;
import org.apache.shardingsphere.infra.metadata.data.builder.ShardingSphereDataBuilderFactory;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.ResourceHeldRule;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.data.ShardingSphereDataPersistService;

public final class MetaDataContexts
implements AutoCloseable {
    private final MetaDataPersistService persistService;
    private final ShardingSphereMetaData metaData;
    private final ShardingSphereData shardingSphereData;

    public MetaDataContexts(MetaDataPersistService persistService, ShardingSphereMetaData metaData) {
        this.persistService = persistService;
        this.metaData = metaData;
        this.shardingSphereData = this.initShardingSphereData(persistService, metaData);
    }

    private ShardingSphereData initShardingSphereData(MetaDataPersistService persistService, ShardingSphereMetaData metaData) {
        Optional result = Optional.ofNullable(persistService.getShardingSphereDataPersistService()).flatMap(ShardingSphereDataPersistService::load);
        if (result.isPresent()) {
            return (ShardingSphereData)result.get();
        }
        if (metaData.getDatabases().isEmpty()) {
            return new ShardingSphereData();
        }
        return Optional.ofNullable(((ShardingSphereDatabase)metaData.getDatabases().values().iterator().next()).getProtocolType()).flatMap(protocolType -> ShardingSphereDataBuilderFactory.getInstance((DatabaseType)protocolType).map(builder -> builder.build(metaData))).orElseGet(ShardingSphereData::new);
    }

    @Override
    public void close() {
        this.persistService.getRepository().close();
        this.metaData.getGlobalRuleMetaData().findRules(ResourceHeldRule.class).forEach(ResourceHeldRule::closeStaleResource);
        this.metaData.getDatabases().values().forEach(each -> each.getRuleMetaData().findRules(ResourceHeldRule.class).forEach(ResourceHeldRule::closeStaleResource));
    }

    @Generated
    public MetaDataPersistService getPersistService() {
        return this.persistService;
    }

    @Generated
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public ShardingSphereData getShardingSphereData() {
        return this.shardingSphereData;
    }
}

