/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.datasource.state.DataSourceState;
import org.apache.shardingsphere.infra.datasource.state.DataSourceStateManager;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.jdbc.JDBCInstanceMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabasesFactory;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;

public final class MetaDataContextsFactory {
    public static MetaDataContexts create(MetaDataPersistService persistService, ContextManagerBuilderParameter parameter, InstanceContext instanceContext) throws SQLException {
        return MetaDataContextsFactory.create(persistService, parameter, instanceContext, Collections.emptyMap());
    }

    public static MetaDataContexts create(MetaDataPersistService persistService, ContextManagerBuilderParameter parameter, InstanceContext instanceContext, Map<String, StorageNodeDataSource> storageNodes) throws SQLException {
        Collection<String> databaseNames = instanceContext.getInstance().getMetaData() instanceof JDBCInstanceMetaData ? parameter.getDatabaseConfigs().keySet() : persistService.getDatabaseMetaDataService().loadAllDatabaseNames();
        Map<String, DatabaseConfiguration> effectiveDatabaseConfigs = MetaDataContextsFactory.createEffectiveDatabaseConfigurations(databaseNames, parameter.getDatabaseConfigs(), persistService);
        MetaDataContextsFactory.checkDataSourceStates(effectiveDatabaseConfigs, storageNodes, parameter.isForce());
        Object globalRuleConfigs = persistService.getGlobalRuleService().load();
        ConfigurationProperties props = new ConfigurationProperties(persistService.getPropsService().load());
        Map databases = ShardingSphereDatabasesFactory.create(effectiveDatabaseConfigs, (ConfigurationProperties)props, (InstanceContext)instanceContext);
        databases.putAll(MetaDataContextsFactory.reloadDatabases(databases, persistService));
        ShardingSphereRuleMetaData globalMetaData = new ShardingSphereRuleMetaData(GlobalRulesBuilder.buildRules((Collection)globalRuleConfigs, (Map)databases, (InstanceContext)instanceContext, (ConfigurationProperties)props));
        return new MetaDataContexts(persistService, new ShardingSphereMetaData(databases, globalMetaData, props));
    }

    private static Map<String, DatabaseConfiguration> createEffectiveDatabaseConfigurations(Collection<String> databaseNames, Map<String, DatabaseConfiguration> databaseConfigs, MetaDataPersistService persistService) {
        return databaseNames.stream().collect(Collectors.toMap(each -> each, each -> MetaDataContextsFactory.createEffectiveDatabaseConfiguration(each, databaseConfigs, persistService), (a, b) -> b, () -> new HashMap(databaseNames.size(), 1.0f)));
    }

    private static DatabaseConfiguration createEffectiveDatabaseConfiguration(String databaseName, Map<String, DatabaseConfiguration> databaseConfigs, MetaDataPersistService persistService) {
        Map<String, DataSource> effectiveDataSources = persistService.getEffectiveDataSources(databaseName, databaseConfigs);
        Object databaseRuleConfigs = persistService.getDatabaseRulePersistService().load(databaseName);
        return new DataSourceProvidedDatabaseConfiguration(effectiveDataSources, (Collection)databaseRuleConfigs);
    }

    private static void checkDataSourceStates(Map<String, DatabaseConfiguration> databaseConfigs, Map<String, StorageNodeDataSource> storageNodes, boolean force) {
        Map<String, DataSourceState> storageDataSourceStates = MetaDataContextsFactory.getStorageDataSourceStates(storageNodes);
        databaseConfigs.forEach((key, value) -> {
            if (null != value.getDataSources() && !value.getDataSources().isEmpty()) {
                DataSourceStateManager.getInstance().initStates(key, value.getDataSources(), storageDataSourceStates, force);
            }
        });
    }

    private static Map<String, DataSourceState> getStorageDataSourceStates(Map<String, StorageNodeDataSource> storageDataSourceStates) {
        HashMap<String, DataSourceState> result = new HashMap<String, DataSourceState>(storageDataSourceStates.size(), 1.0f);
        storageDataSourceStates.forEach((key, value) -> {
            List values = Splitter.on((String)".").splitToList((CharSequence)key);
            Preconditions.checkArgument((3 == values.size() ? 1 : 0) != 0, (Object)"Illegal data source of storage node.");
            String databaseName = (String)values.get(0);
            String dataSourceName = (String)values.get(2);
            result.put(databaseName + "." + dataSourceName, DataSourceState.valueOf((String)value.getStatus().toUpperCase()));
        });
        return result;
    }

    private static Map<String, ShardingSphereDatabase> reloadDatabases(Map<String, ShardingSphereDatabase> databases, MetaDataPersistService persistService) {
        ConcurrentHashMap<String, ShardingSphereDatabase> result = new ConcurrentHashMap<String, ShardingSphereDatabase>(databases.size(), 1.0f);
        databases.forEach((key, value) -> {
            Map schemas = persistService.getDatabaseMetaDataService().loadSchemas((String)key);
            result.put(key.toLowerCase(), new ShardingSphereDatabase(value.getName(), value.getProtocolType(), value.getResourceMetaData(), value.getRuleMetaData(), schemas.isEmpty() ? value.getSchemas() : schemas));
        });
        return result;
    }

    @Generated
    private MetaDataContextsFactory() {
    }
}

