/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.mode.metadata.persist.data.ShardingSphereDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.DatabaseMetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.config.database.DataSourcePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.config.database.DatabaseRulePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.config.global.GlobalRulePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.config.global.PropertiesPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class MetaDataPersistService {
    private final PersistRepository repository;
    private final DataSourcePersistService dataSourceService;
    private final DatabaseMetaDataPersistService databaseMetaDataService;
    private final DatabaseRulePersistService databaseRulePersistService;
    private final GlobalRulePersistService globalRuleService;
    private final PropertiesPersistService propsService;
    private final MetaDataVersionPersistService metaDataVersionPersistService;
    private final ShardingSphereDataPersistService shardingSphereDataPersistService;

    public MetaDataPersistService(PersistRepository repository) {
        this.repository = repository;
        this.dataSourceService = new DataSourcePersistService(repository);
        this.databaseMetaDataService = new DatabaseMetaDataPersistService(repository);
        this.databaseRulePersistService = new DatabaseRulePersistService(repository);
        this.globalRuleService = new GlobalRulePersistService(repository);
        this.propsService = new PropertiesPersistService(repository);
        this.metaDataVersionPersistService = new MetaDataVersionPersistService(repository);
        this.shardingSphereDataPersistService = new ShardingSphereDataPersistService(repository);
    }

    public void persistConfigurations(Map<String, ? extends DatabaseConfiguration> databaseConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props) {
        this.globalRuleService.conditionalPersist(globalRuleConfigs);
        this.propsService.conditionalPersist(props);
        for (Map.Entry<String, ? extends DatabaseConfiguration> entry : databaseConfigs.entrySet()) {
            String databaseName = entry.getKey();
            Map<String, DataSourceProperties> dataSourcePropertiesMap = this.getDataSourcePropertiesMap(entry.getValue().getDataSources());
            Collection ruleConfigurations = entry.getValue().getRuleConfigurations();
            if (dataSourcePropertiesMap.isEmpty() && ruleConfigurations.isEmpty()) {
                this.databaseMetaDataService.addDatabase(databaseName);
                continue;
            }
            this.dataSourceService.conditionalPersist(databaseName, this.getDataSourcePropertiesMap(entry.getValue().getDataSources()));
            this.databaseRulePersistService.conditionalPersist(databaseName, entry.getValue().getRuleConfigurations());
        }
    }

    private Map<String, DataSourceProperties> getDataSourcePropertiesMap(Map<String, DataSource> dataSourceMap) {
        LinkedHashMap<String, DataSourceProperties> result = new LinkedHashMap<String, DataSourceProperties>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> each : dataSourceMap.entrySet()) {
            result.put(each.getKey(), DataSourcePropertiesCreator.create((DataSource)each.getValue()));
        }
        return result;
    }

    public Map<String, DataSource> getEffectiveDataSources(String databaseName, Map<String, ? extends DatabaseConfiguration> databaseConfigs) {
        Object persistedDataPropsMap = this.dataSourceService.load(databaseName);
        return databaseConfigs.containsKey(databaseName) ? this.mergeEffectiveDataSources((Map<String, DataSourceProperties>)persistedDataPropsMap, databaseConfigs.get(databaseName).getDataSources()) : DataSourcePoolCreator.create((Map)persistedDataPropsMap);
    }

    private Map<String, DataSource> mergeEffectiveDataSources(Map<String, DataSourceProperties> persistedDataSourcePropsMap, Map<String, DataSource> localConfiguredDataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(persistedDataSourcePropsMap.size(), 1.0f);
        for (Map.Entry<String, DataSourceProperties> entry : persistedDataSourcePropsMap.entrySet()) {
            String dataSourceName = entry.getKey();
            DataSourceProperties persistedDataSourceProps = entry.getValue();
            DataSource localConfiguredDataSource = localConfiguredDataSources.get(dataSourceName);
            if (null == localConfiguredDataSource) {
                result.put(dataSourceName, DataSourcePoolCreator.create((DataSourceProperties)persistedDataSourceProps));
                continue;
            }
            if (DataSourcePropertiesCreator.create((DataSource)localConfiguredDataSource).equals((Object)persistedDataSourceProps)) {
                result.put(dataSourceName, localConfiguredDataSource);
                continue;
            }
            result.put(dataSourceName, DataSourcePoolCreator.create((DataSourceProperties)persistedDataSourceProps));
            new DataSourcePoolDestroyer(localConfiguredDataSource).asyncDestroy();
        }
        return result;
    }

    @Generated
    public PersistRepository getRepository() {
        return this.repository;
    }

    @Generated
    public DataSourcePersistService getDataSourceService() {
        return this.dataSourceService;
    }

    @Generated
    public DatabaseMetaDataPersistService getDatabaseMetaDataService() {
        return this.databaseMetaDataService;
    }

    @Generated
    public DatabaseRulePersistService getDatabaseRulePersistService() {
        return this.databaseRulePersistService;
    }

    @Generated
    public GlobalRulePersistService getGlobalRuleService() {
        return this.globalRuleService;
    }

    @Generated
    public PropertiesPersistService getPropsService() {
        return this.propsService;
    }

    @Generated
    public MetaDataVersionPersistService getMetaDataVersionPersistService() {
        return this.metaDataVersionPersistService;
    }

    @Generated
    public ShardingSphereDataPersistService getShardingSphereDataPersistService() {
        return this.shardingSphereDataPersistService;
    }
}

