/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.data;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereTableData;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereTableData;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlShardingSphereTableDataSwapper;
import org.apache.shardingsphere.mode.metadata.persist.node.ShardingSphereDataNode;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class ShardingSphereDataPersistService {
    private final PersistRepository repository;

    public ShardingSphereDataPersistService(PersistRepository repository) {
        this.repository = repository;
    }

    public Optional<ShardingSphereData> load() {
        List<String> databaseNames = this.repository.getChildrenKeys(ShardingSphereDataNode.getShardingSphereDataNodePath());
        if (databaseNames.isEmpty()) {
            return Optional.empty();
        }
        ShardingSphereData result = new ShardingSphereData();
        for (String each : databaseNames) {
            ShardingSphereDatabaseData databaseData = this.loadDatabaseData(each);
            result.getDatabaseData().put(each, databaseData);
        }
        return Optional.of(result);
    }

    private ShardingSphereDatabaseData loadDatabaseData(String databaseName) {
        List<String> schemaNames = this.repository.getChildrenKeys(ShardingSphereDataNode.getSchemasPath(databaseName));
        if (schemaNames.isEmpty()) {
            return new ShardingSphereDatabaseData();
        }
        ShardingSphereDatabaseData result = new ShardingSphereDatabaseData();
        for (String each : schemaNames) {
            ShardingSphereSchemaData schemaData = this.loadSchemaData(databaseName, each);
            result.getSchemaData().put(each, schemaData);
        }
        return result;
    }

    private ShardingSphereSchemaData loadSchemaData(String databaseName, String schemaName) {
        List<String> tableNames = this.repository.getChildrenKeys(ShardingSphereDataNode.getTablesPath(databaseName, schemaName));
        if (tableNames.isEmpty()) {
            return new ShardingSphereSchemaData();
        }
        ShardingSphereSchemaData result = new ShardingSphereSchemaData();
        for (String each : tableNames) {
            ShardingSphereTableData tableData = this.loadTableData(databaseName, schemaName, each);
            result.getTableData().put(each, tableData);
        }
        return result;
    }

    private ShardingSphereTableData loadTableData(String databaseName, String schemaName, String tableName) {
        String tableData = this.repository.getDirectly(ShardingSphereDataNode.getTablePath(databaseName, schemaName, tableName));
        return new YamlShardingSphereTableDataSwapper().swapToObject((YamlShardingSphereTableData)YamlEngine.unmarshal((String)tableData, YamlShardingSphereTableData.class));
    }

    public void persist(String databaseName, String schemaName, ShardingSphereSchemaData schemaData) {
        if (schemaData.getTableData().isEmpty()) {
            this.repository.persist(ShardingSphereDataNode.getSchemaDataPath(databaseName, schemaName), "");
        } else {
            this.persistTables(databaseName, schemaName, schemaData.getTableData().values());
        }
    }

    public void persistTables(String databaseName, String schemaName, Collection<ShardingSphereTableData> tables) {
        tables.forEach(each -> this.repository.persist(ShardingSphereDataNode.getTablePath(databaseName, schemaName, each.getName().toLowerCase()), YamlEngine.marshal((Object)new YamlShardingSphereTableDataSwapper().swapToYamlConfiguration(each))));
    }

    @Generated
    public PersistRepository getRepository() {
        return this.repository;
    }
}

