/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;

public final class ComputeNode {
    private static final String ROOT_NODE = "nodes";
    private static final String COMPUTE_NODE = "compute_nodes";
    private static final String ONLINE_NODE = "online";
    private static final String LABELS_NODE = "labels";
    private static final String PROCESS_TRIGGER = "process_trigger";
    private static final String PROCESS_KILL = "process_kill";
    private static final String STATUS_NODE = "status";
    private static final String WORKER_ID = "worker_id";

    public static String getOnlineNodePath(InstanceType instanceType) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE, instanceType.name().toLowerCase());
    }

    public static String getOnlineInstanceNodePath(String instanceId, InstanceType instanceType) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE, instanceType.name().toLowerCase(), instanceId);
    }

    public static String getOnlineInstanceNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE);
    }

    public static String getProcessTriggerNodePatch() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, PROCESS_TRIGGER);
    }

    public static String getProcessKillNodePatch() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, PROCESS_KILL);
    }

    public static String getProcessTriggerInstanceIdNodePath(String instanceId, String processListId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, PROCESS_TRIGGER, String.join((CharSequence)":", instanceId, processListId));
    }

    public static String getProcessKillInstanceIdNodePath(String instanceId, String processListId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, PROCESS_KILL, String.join((CharSequence)":", instanceId, processListId));
    }

    public static String getInstanceLabelsNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, LABELS_NODE, instanceId);
    }

    public static String getComputeNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE);
    }

    public static String getInstanceWorkerIdNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, WORKER_ID, instanceId);
    }

    public static String getInstanceWorkerIdRootNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, WORKER_ID);
    }

    public static String getInstanceIdByComputeNode(String computeNodePath) {
        Pattern pattern = Pattern.compile(ComputeNode.getComputeNodePath() + "(/status|/worker_id|/labels)/([\\S]+)$", 2);
        Matcher matcher = pattern.matcher(computeNodePath);
        return matcher.find() ? matcher.group(2) : "";
    }

    public static String getInstanceStatusNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, STATUS_NODE, instanceId);
    }
}

