/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class DatabaseMetaDataNode {
    private static final String ROOT_NODE = "metadata";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String DATA_SOURCE_NODE = "dataSources";
    private static final String RULE_NODE = "rules";
    private static final String TABLES_NODE = "tables";
    private static final String VIEWS_NODE = "views";
    private static final String ACTIVE_VERSION = "active_version";
    private static final String VERSIONS = "versions";

    public static String getMetaDataDataSourcePath(String databaseName, String version) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getFullMetaDataPath(databaseName, VERSIONS), version, DATA_SOURCE_NODE);
    }

    public static String getMetaDataNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE);
    }

    public static String getDatabaseNamePath(String databaseName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getMetaDataNodePath(), databaseName);
    }

    public static String getRulePath(String databaseName, String version) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getFullMetaDataPath(databaseName, VERSIONS), version, RULE_NODE);
    }

    public static String getMetaDataTablesPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getMetaDataSchemaPath(databaseName, schemaName), TABLES_NODE);
    }

    public static String getMetaDataViewsPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getMetaDataSchemaPath(databaseName, schemaName), VIEWS_NODE);
    }

    public static String getMetaDataSchemaPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getMetaDataSchemasPath(databaseName), schemaName);
    }

    public static String getMetaDataSchemasPath(String databaseName) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getDatabaseNamePath(databaseName), SCHEMAS_NODE);
    }

    public static String getTableMetaDataPath(String databaseName, String schemaName, String table) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getMetaDataTablesPath(databaseName, schemaName), table);
    }

    public static String getViewMetaDataPath(String databaseName, String schemaName, String view) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getMetaDataViewsPath(databaseName, schemaName), view);
    }

    private static String getFullMetaDataPath(String databaseName, String node) {
        return String.join((CharSequence)"/", "", ROOT_NODE, databaseName, node);
    }

    public static Optional<String> getDatabaseName(String configNodeFullPath) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(configNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> getSchemaName(String configNodeFullPath) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)/schemas/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(configNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getDatabaseNameByDatabasePath(String databasePath) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)?", 2);
        Matcher matcher = pattern.matcher(databasePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> getSchemaNameBySchemaPath(String schemaPath) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)/schemas/([\\w\\-]+)?", 2);
        Matcher matcher = pattern.matcher(schemaPath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getTableName(String tableMetaDataPath) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)/([\\w\\-]+)/([\\w\\-]+)/tables/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(tableMetaDataPath);
        return matcher.find() ? Optional.of(matcher.group(4)) : Optional.empty();
    }

    public static Optional<String> getViewName(String viewMetaDataPath) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)/([\\w\\-]+)/([\\w\\-]+)/views/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(viewMetaDataPath);
        return matcher.find() ? Optional.of(matcher.group(4)) : Optional.empty();
    }

    public static String getActiveVersionPath(String databaseName) {
        return DatabaseMetaDataNode.getFullMetaDataPath(databaseName, ACTIVE_VERSION);
    }

    public static String getDatabaseVersionPath(String databaseName, String version) {
        return String.join((CharSequence)"/", DatabaseMetaDataNode.getFullMetaDataPath(databaseName, VERSIONS), version);
    }

    public static Optional<String> getVersionByDataSourcesPath(String dataSourceNodeFullPath) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)/versions/([\\w\\-]+)/dataSources", 2);
        Matcher matcher = pattern.matcher(dataSourceNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getVersionByRulesPath(String rulesNodeFullPath) {
        Pattern pattern = Pattern.compile(DatabaseMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)/versions/([\\w\\-]+)/rules", 2);
        Matcher matcher = pattern.matcher(rulesNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    @Generated
    private DatabaseMetaDataNode() {
    }
}

