/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class ShardingSphereDataNode {
    private static final String ROOT_NODE = "sys_data";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String TABLES_NODE = "tables";

    public static String getShardingSphereDataNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE);
    }

    public static String getDatabaseNamePath(String databaseName) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getShardingSphereDataNodePath(), databaseName);
    }

    public static String getTablesPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getSchemaDataPath(databaseName, schemaName), TABLES_NODE);
    }

    public static String getSchemaDataPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getSchemasPath(databaseName), schemaName);
    }

    public static String getSchemasPath(String databaseName) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getDatabaseNamePath(databaseName), SCHEMAS_NODE);
    }

    public static String getTablePath(String databaseName, String schemaName, String table) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getTablesPath(databaseName, schemaName), table);
    }

    public static Optional<String> getDatabaseName(String configNodeFullPath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(configNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> getSchemaName(String configNodeFullPath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)/schemas/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(configNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getDatabaseNameByDatabasePath(String databasePath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)?", 2);
        Matcher matcher = pattern.matcher(databasePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> getSchemaNameBySchemaPath(String schemaPath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)/schemas/([\\w\\-]+)?", 2);
        Matcher matcher = pattern.matcher(schemaPath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getTableName(String tableMetaDataPath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)/([\\w\\-]+)/([\\w\\-]+)/tables/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(tableMetaDataPath);
        return matcher.find() ? Optional.of(matcher.group(4)) : Optional.empty();
    }

    @Generated
    private ShardingSphereDataNode() {
    }
}

