/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.SchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.mode.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.schema.TableMetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.schema.ViewMetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class DatabaseMetaDataPersistService {
    private final PersistRepository repository;
    private final TableMetaDataPersistService tableMetaDataPersistService;
    private final ViewMetaDataPersistService viewMetaDataPersistService;

    public DatabaseMetaDataPersistService(PersistRepository repository) {
        this.repository = repository;
        this.tableMetaDataPersistService = new TableMetaDataPersistService(repository);
        this.viewMetaDataPersistService = new ViewMetaDataPersistService(repository);
    }

    public void addDatabase(String databaseName) {
        this.repository.persist(DatabaseMetaDataNode.getDatabaseNamePath(databaseName), "");
    }

    public void dropDatabase(String databaseName) {
        this.repository.delete(DatabaseMetaDataNode.getDatabaseNamePath(databaseName));
    }

    public Collection<String> loadAllDatabaseNames() {
        return this.repository.getChildrenKeys(DatabaseMetaDataNode.getMetaDataNodePath());
    }

    public void addSchema(String databaseName, String schemaName) {
        this.repository.persist(DatabaseMetaDataNode.getMetaDataTablesPath(databaseName, schemaName), "");
    }

    public void dropSchema(String databaseName, String schemaName) {
        this.repository.delete(DatabaseMetaDataNode.getMetaDataSchemaPath(databaseName, schemaName));
    }

    public void compareAndPersist(String databaseName, String schemaName, ShardingSphereSchema schema) {
        if (schema.getTables().isEmpty() && schema.getViews().isEmpty()) {
            this.addSchema(databaseName, schemaName);
        }
        Object currentTables = this.tableMetaDataPersistService.load(databaseName, schemaName);
        this.tableMetaDataPersistService.persist(databaseName, schemaName, SchemaManager.getToBeAddedTables((Map)schema.getTables(), (Map)currentTables));
        SchemaManager.getToBeDeletedTables((Map)schema.getTables(), (Map)currentTables).forEach((key, value) -> this.tableMetaDataPersistService.delete(databaseName, schemaName, (String)key));
    }

    public void persist(String databaseName, String schemaName, ShardingSphereSchema schema) {
        if (schema.getTables().isEmpty() && schema.getViews().isEmpty()) {
            this.addSchema(databaseName, schemaName);
        }
        this.tableMetaDataPersistService.persist(databaseName, schemaName, schema.getTables());
    }

    public void delete(String databaseName, String schemaName, ShardingSphereSchema schema) {
        schema.getTables().forEach((key, value) -> this.tableMetaDataPersistService.delete(databaseName, schemaName, (String)key));
    }

    public Map<String, ShardingSphereSchema> loadSchemas(String databaseName) {
        Collection<String> schemaNames = this.loadAllSchemaNames(databaseName);
        LinkedHashMap<String, ShardingSphereSchema> result = new LinkedHashMap<String, ShardingSphereSchema>(schemaNames.size(), 1.0f);
        schemaNames.forEach(each -> result.put(each.toLowerCase(), new ShardingSphereSchema((Map)this.tableMetaDataPersistService.load(databaseName, (String)each), (Map)this.viewMetaDataPersistService.load(databaseName, (String)each))));
        return result;
    }

    private Collection<String> loadAllSchemaNames(String databaseName) {
        return this.repository.getChildrenKeys(DatabaseMetaDataNode.getMetaDataSchemasPath(databaseName));
    }

    @Generated
    public PersistRepository getRepository() {
        return this.repository;
    }

    @Generated
    public TableMetaDataPersistService getTableMetaDataPersistService() {
        return this.tableMetaDataPersistService;
    }

    @Generated
    public ViewMetaDataPersistService getViewMetaDataPersistService() {
        return this.viewMetaDataPersistService;
    }
}

