/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.shardingsphere.mode.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class MetaDataVersionPersistService {
    private final PersistRepository repository;

    public Optional<String> getActiveVersion(String databaseName) {
        return Optional.ofNullable(this.repository.getDirectly(DatabaseMetaDataNode.getActiveVersionPath(databaseName)));
    }

    public boolean isActiveVersion(String databaseName, String version) {
        Optional<String> actualVersion = this.getActiveVersion(databaseName);
        return actualVersion.isPresent() && actualVersion.get().equals(version);
    }

    public Optional<String> createNewVersion(String databaseName) {
        Optional<String> activeVersion = this.getActiveVersion(databaseName);
        if (!activeVersion.isPresent()) {
            return Optional.empty();
        }
        String newVersion = String.valueOf(new AtomicLong(Long.parseLong(activeVersion.get())).incrementAndGet());
        this.repository.persist(DatabaseMetaDataNode.getRulePath(databaseName, newVersion), this.repository.getDirectly(DatabaseMetaDataNode.getRulePath(databaseName, activeVersion.get())));
        this.repository.persist(DatabaseMetaDataNode.getMetaDataDataSourcePath(databaseName, newVersion), this.repository.getDirectly(DatabaseMetaDataNode.getMetaDataDataSourcePath(databaseName, activeVersion.get())));
        return Optional.of(newVersion);
    }

    public void persistActiveVersion(String databaseName, String version) {
        Optional<String> activeVersion = this.getActiveVersion(databaseName);
        if (activeVersion.isPresent() && !activeVersion.get().equals(version)) {
            this.repository.persist(DatabaseMetaDataNode.getActiveVersionPath(databaseName), version);
        }
    }

    public void deleteVersion(String databaseName, String version) {
        this.repository.delete(DatabaseMetaDataNode.getDatabaseVersionPath(databaseName, version));
    }

    @Generated
    public MetaDataVersionPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

