/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.config.database;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.mode.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.config.database.DatabaseBasedPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class DataSourcePersistService
implements DatabaseBasedPersistService<Map<String, DataSourceProperties>> {
    private static final String DEFAULT_VERSION = "0";
    private final PersistRepository repository;

    @Override
    public void conditionalPersist(String databaseName, Map<String, DataSourceProperties> dataSourcePropsMap) {
        if (!dataSourcePropsMap.isEmpty() && !this.isExisted(databaseName)) {
            this.persist(databaseName, dataSourcePropsMap);
        }
    }

    @Override
    public void persist(String databaseName, Map<String, DataSourceProperties> dataSourcePropsMap) {
        if (Strings.isNullOrEmpty((String)this.getDatabaseActiveVersion(databaseName))) {
            this.repository.persist(DatabaseMetaDataNode.getActiveVersionPath(databaseName), DEFAULT_VERSION);
        }
        this.repository.persist(DatabaseMetaDataNode.getMetaDataDataSourcePath(databaseName, this.getDatabaseActiveVersion(databaseName)), YamlEngine.marshal(this.swapYamlDataSourceConfiguration(dataSourcePropsMap)));
    }

    @Override
    public void persist(String databaseName, String version, Map<String, DataSourceProperties> dataSourcePropsMap) {
        this.repository.persist(DatabaseMetaDataNode.getMetaDataDataSourcePath(databaseName, version), YamlEngine.marshal(this.swapYamlDataSourceConfiguration(dataSourcePropsMap)));
    }

    private Map<String, Map<String, Object>> swapYamlDataSourceConfiguration(Map<String, DataSourceProperties> dataSourcePropsMap) {
        return dataSourcePropsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new YamlDataSourceConfigurationSwapper().swapToMap((DataSourceProperties)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    @Override
    public Map<String, DataSourceProperties> load(String databaseName) {
        return this.isExisted(databaseName) ? this.getDataSourceProperties(this.repository.getDirectly(DatabaseMetaDataNode.getMetaDataDataSourcePath(databaseName, this.getDatabaseActiveVersion(databaseName)))) : new LinkedHashMap<String, DataSourceProperties>();
    }

    @Override
    public Map<String, DataSourceProperties> load(String databaseName, String version) {
        String yamlContent = this.repository.getDirectly(DatabaseMetaDataNode.getMetaDataDataSourcePath(databaseName, version));
        return Strings.isNullOrEmpty((String)yamlContent) ? new LinkedHashMap() : this.getDataSourceProperties(yamlContent);
    }

    private Map<String, DataSourceProperties> getDataSourceProperties(String yamlContent) {
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)yamlContent, Map.class);
        if (yamlDataSources.isEmpty()) {
            return new LinkedHashMap<String, DataSourceProperties>();
        }
        LinkedHashMap<String, DataSourceProperties> result = new LinkedHashMap<String, DataSourceProperties>(yamlDataSources.size());
        yamlDataSources.forEach((key, value) -> result.put((String)key, new YamlDataSourceConfigurationSwapper().swapToDataSourceProperties(value)));
        return result;
    }

    @Override
    public boolean isExisted(String databaseName) {
        return !Strings.isNullOrEmpty((String)this.getDatabaseActiveVersion(databaseName)) && !Strings.isNullOrEmpty((String)this.repository.getDirectly(DatabaseMetaDataNode.getMetaDataDataSourcePath(databaseName, this.getDatabaseActiveVersion(databaseName))));
    }

    public void append(String databaseName, Map<String, DataSourceProperties> toBeAppendedDataSourcePropsMap) {
        Object dataSourceConfigs = this.load(databaseName);
        dataSourceConfigs.putAll(toBeAppendedDataSourcePropsMap);
        this.persist(databaseName, (Map<String, DataSourceProperties>)dataSourceConfigs);
    }

    private String getDatabaseActiveVersion(String databaseName) {
        return this.repository.getDirectly(DatabaseMetaDataNode.getActiveVersionPath(databaseName));
    }

    @Generated
    public DataSourcePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

