/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.config.global;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.GlobalNode;
import org.apache.shardingsphere.mode.metadata.persist.service.config.global.GlobalPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class GlobalRulePersistService
implements GlobalPersistService<Collection<RuleConfiguration>> {
    private final PersistRepository repository;

    @Override
    public void conditionalPersist(Collection<RuleConfiguration> globalRuleConfigs) {
        if (!globalRuleConfigs.isEmpty() && !this.isExisted()) {
            this.persist(globalRuleConfigs);
        }
    }

    @Override
    public void persist(Collection<RuleConfiguration> globalRuleConfigs) {
        this.repository.persist(GlobalNode.getGlobalRuleNode(), YamlEngine.marshal((Object)new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfigurations(globalRuleConfigs)));
    }

    @Override
    public Collection<RuleConfiguration> load() {
        return this.isExisted() ? new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations((Collection)YamlEngine.unmarshal((String)this.repository.getDirectly(GlobalNode.getGlobalRuleNode()), Collection.class)) : Collections.emptyList();
    }

    private boolean isExisted() {
        return !Strings.isNullOrEmpty((String)this.repository.getDirectly(GlobalNode.getGlobalRuleNode()));
    }

    public Collection<ShardingSphereUser> loadUsers() {
        Optional<AuthorityRuleConfiguration> authorityRuleConfig = this.load().stream().filter(each -> each instanceof AuthorityRuleConfiguration).map(each -> (AuthorityRuleConfiguration)each).findFirst();
        return authorityRuleConfig.isPresent() ? authorityRuleConfig.get().getUsers() : Collections.emptyList();
    }

    @Generated
    public GlobalRulePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

