/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.config.global;

import com.google.common.base.Strings;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.GlobalNode;
import org.apache.shardingsphere.mode.metadata.persist.service.config.global.GlobalPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class PropertiesPersistService
implements GlobalPersistService<Properties> {
    private final PersistRepository repository;

    @Override
    public void conditionalPersist(Properties props) {
        if (!props.isEmpty() && !this.isExisted()) {
            this.persist(props);
        }
    }

    @Override
    public void persist(Properties props) {
        this.repository.persist(GlobalNode.getPropsPath(), YamlEngine.marshal((Object)props));
    }

    private boolean isExisted() {
        return !Strings.isNullOrEmpty((String)this.repository.getDirectly(GlobalNode.getPropsPath()));
    }

    @Override
    public Properties load() {
        return Strings.isNullOrEmpty((String)this.repository.getDirectly(GlobalNode.getPropsPath())) ? new Properties() : (Properties)YamlEngine.unmarshal((String)this.repository.getDirectly(GlobalNode.getPropsPath()), Properties.class);
    }

    @Generated
    public PropertiesPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

