/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.schema;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlTableSwapper;
import org.apache.shardingsphere.mode.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.schema.SchemaMetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class TableMetaDataPersistService
implements SchemaMetaDataPersistService<Map<String, ShardingSphereTable>> {
    private final PersistRepository repository;

    @Override
    public void persist(String databaseName, String schemaName, Map<String, ShardingSphereTable> tables) {
        tables.forEach((key, value) -> this.repository.persist(DatabaseMetaDataNode.getTableMetaDataPath(databaseName, schemaName, key.toLowerCase()), YamlEngine.marshal((Object)new YamlTableSwapper().swapToYamlConfiguration(value))));
    }

    @Override
    public Map<String, ShardingSphereTable> load(String databaseName, String schemaName) {
        List<String> tableNames = this.repository.getChildrenKeys(DatabaseMetaDataNode.getMetaDataTablesPath(databaseName, schemaName));
        return tableNames.isEmpty() ? Collections.emptyMap() : this.getTableMetaDataByTableNames(databaseName, schemaName, tableNames);
    }

    @Override
    public void delete(String databaseName, String schemaName, String tableName) {
        this.repository.delete(DatabaseMetaDataNode.getTableMetaDataPath(databaseName, schemaName, tableName.toLowerCase()));
    }

    private Map<String, ShardingSphereTable> getTableMetaDataByTableNames(String databaseName, String schemaName, Collection<String> tableNames) {
        LinkedHashMap<String, ShardingSphereTable> result = new LinkedHashMap<String, ShardingSphereTable>(tableNames.size(), 1.0f);
        tableNames.forEach(each -> {
            String table = this.repository.getDirectly(DatabaseMetaDataNode.getTableMetaDataPath(databaseName, schemaName, each));
            if (!Strings.isNullOrEmpty((String)table)) {
                result.put(each.toLowerCase(), new YamlTableSwapper().swapToObject((YamlShardingSphereTable)YamlEngine.unmarshal((String)table, YamlShardingSphereTable.class)));
            }
        });
        return result;
    }

    @Generated
    public TableMetaDataPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

