/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.schema;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereView;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereView;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlViewSwapper;
import org.apache.shardingsphere.mode.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.schema.SchemaMetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class ViewMetaDataPersistService
implements SchemaMetaDataPersistService<Map<String, ShardingSphereView>> {
    private final PersistRepository repository;

    @Override
    public void persist(String databaseName, String schemaName, Map<String, ShardingSphereView> views) {
        views.forEach((key, value) -> this.repository.persist(DatabaseMetaDataNode.getViewMetaDataPath(databaseName, schemaName, key.toLowerCase()), YamlEngine.marshal((Object)new YamlViewSwapper().swapToYamlConfiguration(value))));
    }

    @Override
    public Map<String, ShardingSphereView> load(String databaseName, String schemaName) {
        List<String> viewNames = this.repository.getChildrenKeys(DatabaseMetaDataNode.getMetaDataViewsPath(databaseName, schemaName));
        return viewNames.isEmpty() ? Collections.emptyMap() : this.getViewMetaDataByViewNames(databaseName, schemaName, viewNames);
    }

    @Override
    public void delete(String databaseName, String schemaName, String viewName) {
        this.repository.delete(DatabaseMetaDataNode.getViewMetaDataPath(databaseName, schemaName, viewName.toLowerCase()));
    }

    private Map<String, ShardingSphereView> getViewMetaDataByViewNames(String databaseName, String schemaName, Collection<String> viewNames) {
        LinkedHashMap<String, ShardingSphereView> result = new LinkedHashMap<String, ShardingSphereView>(viewNames.size(), 1.0f);
        viewNames.forEach(each -> {
            String view = this.repository.getDirectly(DatabaseMetaDataNode.getViewMetaDataPath(databaseName, schemaName, each));
            if (!Strings.isNullOrEmpty((String)view)) {
                result.put(each.toLowerCase(), new YamlViewSwapper().swapToObject((YamlShardingSphereView)YamlEngine.unmarshal((String)view, YamlShardingSphereView.class)));
            }
        });
        return result;
    }

    @Generated
    public ViewMetaDataPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

