/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.process;

import java.util.Optional;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessConstants;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessContext;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessUnit;
import org.apache.shardingsphere.infra.executor.sql.process.spi.ExecuteProcessReporter;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.process.ShowProcessListManager;

public final class GovernanceExecuteProcessReporter
implements ExecuteProcessReporter {
    public void report(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext) {
        ExecuteProcessContext executeProcessContext = new ExecuteProcessContext("", executionGroupContext, ExecuteProcessConstants.EXECUTE_STATUS_SLEEP, true);
        ShowProcessListManager.getInstance().putProcessContext(executeProcessContext.getExecutionID(), executeProcessContext);
    }

    public void report(QueryContext queryContext, ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, ExecuteProcessConstants constants, EventBusContext eventBusContext) {
        ExecuteProcessContext originExecuteProcessContext = ShowProcessListManager.getInstance().getProcessContext(executionGroupContext.getExecutionID());
        boolean isProxyContext = null != originExecuteProcessContext && originExecuteProcessContext.isProxyContext();
        ExecuteProcessContext executeProcessContext = new ExecuteProcessContext(queryContext.getSql(), executionGroupContext, constants, isProxyContext);
        ShowProcessListManager.getInstance().putProcessContext(executeProcessContext.getExecutionID(), executeProcessContext);
        ShowProcessListManager.getInstance().putProcessStatement(executeProcessContext.getExecutionID(), executeProcessContext.getProcessStatements());
    }

    public void report(String executionID, SQLExecutionUnit executionUnit, ExecuteProcessConstants constants, EventBusContext eventBusContext) {
        ExecuteProcessUnit executeProcessUnit = new ExecuteProcessUnit(executionUnit.getExecutionUnit(), constants);
        ExecuteProcessContext executeProcessContext = ShowProcessListManager.getInstance().getProcessContext(executionID);
        Optional.ofNullable(executeProcessContext.getProcessUnits().get(executeProcessUnit.getUnitID())).ifPresent(optional -> optional.setStatus(executeProcessUnit.getStatus()));
    }

    public void report(String executionID, ExecuteProcessConstants constants, EventBusContext eventBusContext) {
    }

    public void reportClean(String executionID) {
        ShowProcessListManager.getInstance().removeProcessStatement(executionID);
        Optional.ofNullable(ShowProcessListManager.getInstance().getProcessContext(executionID)).ifPresent(executeProcessContext -> {
            if (executeProcessContext.isProxyContext()) {
                executeProcessContext.resetExecuteProcessContextToSleep();
            } else {
                ShowProcessListManager.getInstance().removeProcessContext(executionID);
            }
        });
    }

    public void reportRemove(String executionID) {
        ShowProcessListManager.getInstance().removeProcessStatement(executionID);
        ShowProcessListManager.getInstance().removeProcessContext(executionID);
    }
}

