/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.process;

import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessContext;
import org.apache.shardingsphere.mode.process.lock.ShowProcessListSimpleLock;

public final class ShowProcessListManager {
    private static final ShowProcessListManager INSTANCE = new ShowProcessListManager();
    private final Map<String, ExecuteProcessContext> processContexts = new ConcurrentHashMap<String, ExecuteProcessContext>();
    private final Map<String, Collection<Statement>> processStatements = new ConcurrentHashMap<String, Collection<Statement>>();
    private final Map<String, ShowProcessListSimpleLock> locks = new ConcurrentHashMap<String, ShowProcessListSimpleLock>();

    public static ShowProcessListManager getInstance() {
        return INSTANCE;
    }

    public void putProcessContext(String executionId, ExecuteProcessContext processContext) {
        this.processContexts.put(executionId, processContext);
    }

    public void putProcessStatement(String executionId, Collection<Statement> statements) {
        if (statements.isEmpty()) {
            return;
        }
        this.processStatements.put(executionId, statements);
    }

    public ExecuteProcessContext getProcessContext(String executionId) {
        return this.processContexts.get(executionId);
    }

    public Collection<Statement> getProcessStatement(String executionId) {
        return this.processStatements.getOrDefault(executionId, Collections.emptyList());
    }

    public void removeProcessContext(String executionId) {
        this.processContexts.remove(executionId);
    }

    public void removeProcessStatement(String executionId) {
        this.processStatements.remove(executionId);
    }

    public Collection<ExecuteProcessContext> getAllProcessContext() {
        return this.processContexts.values();
    }

    @Generated
    private ShowProcessListManager() {
    }

    @Generated
    public Map<String, ExecuteProcessContext> getProcessContexts() {
        return this.processContexts;
    }

    @Generated
    public Map<String, Collection<Statement>> getProcessStatements() {
        return this.processStatements;
    }

    @Generated
    public Map<String, ShowProcessListSimpleLock> getLocks() {
        return this.locks;
    }
}

