/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.algorithm.loadbalance;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.shardingsphere.infra.context.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.readwritesplitting.exception.algorithm.InvalidReadDatabaseWeightException;
import org.apache.shardingsphere.readwritesplitting.spi.ReadQueryLoadBalanceAlgorithm;

public final class TransactionWeightReadQueryLoadBalanceAlgorithm
implements ReadQueryLoadBalanceAlgorithm {
    private static final double ACCURACY_THRESHOLD = 1.0E-4;
    private static final ConcurrentHashMap<String, double[]> WEIGHT_MAP = new ConcurrentHashMap();
    private Properties props;

    public void init(Properties props) {
        this.props = props;
    }

    public String getDataSource(String name, String writeDataSourceName, List<String> readDataSourceNames, TransactionConnectionContext context) {
        double[] weight = WEIGHT_MAP.containsKey(name) ? WEIGHT_MAP.get(name) : this.initWeight(readDataSourceNames);
        WEIGHT_MAP.putIfAbsent(name, weight);
        return this.getDataSourceName(readDataSourceNames, weight);
    }

    private String getDataSourceName(List<String> readDataSourceNames, double[] weight) {
        double randomWeight = ThreadLocalRandom.current().nextDouble(0.0, 1.0);
        int index = Arrays.binarySearch(weight, randomWeight);
        if (index < 0) {
            return (index = -index - 1) < weight.length && randomWeight < weight[index] ? readDataSourceNames.get(index) : readDataSourceNames.get(readDataSourceNames.size() - 1);
        }
        return readDataSourceNames.get(index);
    }

    private double[] initWeight(List<String> readDataSourceNames) {
        double[] result = this.getWeights(readDataSourceNames);
        Preconditions.checkState((0 == result.length || !(Math.abs(result[result.length - 1] - 1.0) >= 1.0E-4) ? 1 : 0) != 0, (Object)"The cumulative weight is calculated incorrectly, and the sum of the probabilities is not equal to 1");
        return result;
    }

    private double[] getWeights(List<String> readDataSourceNames) {
        double[] exactWeights = new double[readDataSourceNames.size()];
        int index = 0;
        double sum = 0.0;
        for (String readDataSourceName : readDataSourceNames) {
            double weight = this.getWeightValue(readDataSourceName);
            exactWeights[index++] = weight;
            sum += weight;
        }
        for (int i = 0; i < index; ++i) {
            if (exactWeights[i] <= 0.0) continue;
            exactWeights[i] = exactWeights[i] / sum;
        }
        return this.calcWeight(exactWeights);
    }

    private double[] calcWeight(double[] exactWeights) {
        double[] result = new double[exactWeights.length];
        double randomRange = 0.0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = randomRange + exactWeights[i];
            randomRange += exactWeights[i];
        }
        return result;
    }

    private double getWeightValue(String readDataSourceName) {
        double result;
        Object weightObject = this.props.get(readDataSourceName);
        Preconditions.checkNotNull((Object)weightObject, (String)"Read database `%s` access weight is not configured", (Object)readDataSourceName);
        try {
            result = Double.parseDouble(weightObject.toString());
        }
        catch (NumberFormatException ex) {
            throw new InvalidReadDatabaseWeightException(weightObject);
        }
        if (Double.isInfinite(result)) {
            result = 10000.0;
        }
        if (Double.isNaN(result)) {
            result = 1.0;
        }
        return result;
    }

    public String getType() {
        return "TRANSACTION_WEIGHT";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

