/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.checker;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DynamicDataSourceContainedRule;
import org.apache.shardingsphere.infra.util.expr.InlineExpressionParser;
import org.apache.shardingsphere.readwritesplitting.algorithm.loadbalance.TransactionWeightReadQueryLoadBalanceAlgorithm;
import org.apache.shardingsphere.readwritesplitting.algorithm.loadbalance.WeightReadQueryLoadBalanceAlgorithm;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.strategy.DynamicReadwriteSplittingStrategyConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.strategy.StaticReadwriteSplittingStrategyConfiguration;
import org.apache.shardingsphere.readwritesplitting.spi.ReadQueryLoadBalanceAlgorithm;

public abstract class AbstractReadwriteSplittingRuleConfigurationChecker<T extends RuleConfiguration>
implements RuleConfigurationChecker<T> {
    public final void check(String databaseName, T config, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules) {
        Collection<ReadwriteSplittingDataSourceRuleConfiguration> configs = this.getDataSources(config);
        Preconditions.checkArgument((!configs.isEmpty() ? 1 : 0) != 0, (Object)"Readwrite-splitting data source rules can not be empty.");
        this.checkDataSources(databaseName, configs, dataSourceMap, rules);
        this.checkLoadBalancerDataSourceName(databaseName, configs, this.getLoadBalancer(config), rules);
    }

    private void checkDataSources(String databaseName, Collection<ReadwriteSplittingDataSourceRuleConfiguration> configs, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules) {
        HashSet addedWriteDataSourceNames = new HashSet();
        HashSet addedReadDataSourceNames = new HashSet();
        for (ReadwriteSplittingDataSourceRuleConfiguration each : configs) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)each.getName()) ? 1 : 0) != 0, (Object)"Readwrite-splitting data source name is required.");
            Preconditions.checkState((null != each.getStaticStrategy() || null != each.getDynamicStrategy() ? 1 : 0) != 0, (String)"No available readwrite-splitting rule configuration in database `%s`.", (Object)databaseName);
            Optional.ofNullable(each.getStaticStrategy()).ifPresent(optional -> this.checkStaticStrategy(databaseName, dataSourceMap, addedWriteDataSourceNames, addedReadDataSourceNames, (StaticReadwriteSplittingStrategyConfiguration)optional, rules));
            Optional.ofNullable(each.getDynamicStrategy()).ifPresent(optional -> this.checkDynamicStrategy(rules, (DynamicReadwriteSplittingStrategyConfiguration)optional));
        }
    }

    private void checkStaticStrategy(String databaseName, Map<String, DataSource> dataSourceMap, Collection<String> addedWriteDataSourceNames, Collection<String> readDataSourceNames, StaticReadwriteSplittingStrategyConfiguration strategyConfig, Collection<ShardingSphereRule> rules) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)strategyConfig.getWriteDataSourceName()) ? 1 : 0) != 0, (Object)"Write data source name is required.");
        Preconditions.checkArgument((!strategyConfig.getReadDataSourceNames().isEmpty() ? 1 : 0) != 0, (Object)"Read data source names are required.");
        this.checkWriteDataSourceNames(databaseName, dataSourceMap, addedWriteDataSourceNames, strategyConfig, rules);
        for (String each : readDataSourceNames) {
            this.checkReadeDataSourceNames(databaseName, dataSourceMap, readDataSourceNames, each);
        }
    }

    private void checkWriteDataSourceNames(String databaseName, Map<String, DataSource> dataSourceMap, Collection<String> addedWriteDataSourceNames, StaticReadwriteSplittingStrategyConfiguration strategyConfig, Collection<ShardingSphereRule> rules) {
        for (String each : new InlineExpressionParser(strategyConfig.getWriteDataSourceName()).splitAndEvaluate()) {
            Preconditions.checkState((dataSourceMap.containsKey(each) || this.containsInOtherRules(each, rules) ? 1 : 0) != 0, (String)"Write data source name `%s` not in database `%s`.", (Object)each, (Object)databaseName);
            Preconditions.checkState((boolean)addedWriteDataSourceNames.add(each), (String)"Can not config duplicate write data source `%s` in database `%s`.", (Object)each, (Object)databaseName);
        }
    }

    private boolean containsInOtherRules(String datasourceName, Collection<ShardingSphereRule> rules) {
        for (ShardingSphereRule each : rules) {
            if (!(each instanceof DataSourceContainedRule) || !((DataSourceContainedRule)each).getDataSourceMapper().containsKey(datasourceName)) continue;
            return true;
        }
        return false;
    }

    private void checkReadeDataSourceNames(String databaseName, Map<String, DataSource> dataSourceMap, Collection<String> addedReadDataSourceNames, String readDataSourceName) {
        for (String each : new InlineExpressionParser(readDataSourceName).splitAndEvaluate()) {
            Preconditions.checkState((boolean)dataSourceMap.containsKey(each), (String)"Read data source name `%s` not in database `%s`.", (Object)each, (Object)databaseName);
            Preconditions.checkState((boolean)addedReadDataSourceNames.add(each), (String)"Can not config duplicate read data source `%s` in database `%s`.", (Object)each, (Object)databaseName);
        }
    }

    private void checkDynamicStrategy(Collection<ShardingSphereRule> rules, DynamicReadwriteSplittingStrategyConfiguration dynamicStrategy) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dynamicStrategy.getAutoAwareDataSourceName()) ? 1 : 0) != 0, (Object)"Auto aware data source name is required");
        Optional<ShardingSphereRule> dynamicDataSourceStrategy = rules.stream().filter(each -> each instanceof DynamicDataSourceContainedRule).findFirst();
        Preconditions.checkArgument((boolean)dynamicDataSourceStrategy.isPresent(), (Object)"Dynamic data source strategy is required");
    }

    private void checkLoadBalancerDataSourceName(String databaseName, Collection<ReadwriteSplittingDataSourceRuleConfiguration> configs, Map<String, ReadQueryLoadBalanceAlgorithm> loadBalancers, Collection<ShardingSphereRule> rules) {
        for (ReadwriteSplittingDataSourceRuleConfiguration each : configs) {
            if (Strings.isNullOrEmpty((String)each.getLoadBalancerName())) continue;
            ReadQueryLoadBalanceAlgorithm loadBalancer = loadBalancers.get(each.getLoadBalancerName());
            Preconditions.checkNotNull((Object)loadBalancer, (String)"Not found load balance type in database `%s`", (Object)databaseName);
            if (!(loadBalancer instanceof WeightReadQueryLoadBalanceAlgorithm) && !(loadBalancer instanceof TransactionWeightReadQueryLoadBalanceAlgorithm)) continue;
            Preconditions.checkState((!loadBalancer.getProps().isEmpty() ? 1 : 0) != 0, (String)"Readwrite-splitting data source weight config are required in database `%s`", (Object)databaseName);
            List<String> dataSourceNames = this.getDataSourceNames(each, rules);
            loadBalancer.getProps().stringPropertyNames().forEach(dataSourceName -> Preconditions.checkState((boolean)dataSourceNames.contains(dataSourceName), (String)"Load Balancer datasource name config does not match datasource in database `%s`", (Object)databaseName));
        }
    }

    private List<String> getDataSourceNames(ReadwriteSplittingDataSourceRuleConfiguration config, Collection<ShardingSphereRule> rules) {
        if (null != config.getStaticStrategy()) {
            return config.getStaticStrategy().getReadDataSourceNames();
        }
        Optional<ShardingSphereRule> dynamicDataSourceStrategy = rules.stream().filter(each -> each instanceof DynamicDataSourceContainedRule).findFirst();
        if (!dynamicDataSourceStrategy.isPresent()) {
            return Collections.emptyList();
        }
        DynamicDataSourceContainedRule dynamicDataSourceRule = (DynamicDataSourceContainedRule)dynamicDataSourceStrategy.get();
        ArrayList<String> result = new ArrayList<String>(dynamicDataSourceRule.getReplicaDataSourceNames(config.getDynamicStrategy().getAutoAwareDataSourceName()));
        result.add(dynamicDataSourceRule.getPrimaryDataSourceName(config.getDynamicStrategy().getAutoAwareDataSourceName()));
        return result;
    }

    protected abstract Collection<ReadwriteSplittingDataSourceRuleConfiguration> getDataSources(T var1);

    protected abstract Map<String, ReadQueryLoadBalanceAlgorithm> getLoadBalancer(T var1);
}

