/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.identifier.scope.DatabaseRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StaticDataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StorageConnectorReusableRule;
import org.apache.shardingsphere.infra.rule.identifier.type.exportable.ExportableRule;
import org.apache.shardingsphere.infra.util.expr.InlineExpressionParser;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.metadata.storage.event.StorageNodeDataSourceChangedEvent;
import org.apache.shardingsphere.readwritesplitting.algorithm.config.AlgorithmProvidedReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.strategy.DynamicReadwriteSplittingStrategyConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.strategy.StaticReadwriteSplittingStrategyConfiguration;
import org.apache.shardingsphere.readwritesplitting.factory.ReadQueryLoadBalanceAlgorithmFactory;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceRule;
import org.apache.shardingsphere.readwritesplitting.spi.ReadQueryLoadBalanceAlgorithm;
import org.apache.shardingsphere.readwritesplitting.strategy.type.DynamicReadwriteSplittingStrategy;
import org.apache.shardingsphere.readwritesplitting.strategy.type.StaticReadwriteSplittingStrategy;

public final class ReadwriteSplittingRule
implements DatabaseRule,
DataSourceContainedRule,
StaticDataSourceContainedRule,
ExportableRule,
StorageConnectorReusableRule {
    private final RuleConfiguration configuration;
    private final Map<String, ReadQueryLoadBalanceAlgorithm> loadBalancers = new LinkedHashMap<String, ReadQueryLoadBalanceAlgorithm>();
    private final Map<String, ReadwriteSplittingDataSourceRule> dataSourceRules;

    public ReadwriteSplittingRule(ReadwriteSplittingRuleConfiguration ruleConfig, Collection<ShardingSphereRule> builtRules) {
        this.configuration = ruleConfig;
        ruleConfig.getLoadBalancers().forEach((key, value) -> this.loadBalancers.put((String)key, ReadQueryLoadBalanceAlgorithmFactory.newInstance((AlgorithmConfiguration)value)));
        this.dataSourceRules = new HashMap<String, ReadwriteSplittingDataSourceRule>(ruleConfig.getDataSources().size(), 1.0f);
        for (ReadwriteSplittingDataSourceRuleConfiguration each : ruleConfig.getDataSources()) {
            this.dataSourceRules.putAll(this.createReadwriteSplittingDataSourceRules(each, builtRules));
        }
    }

    public ReadwriteSplittingRule(AlgorithmProvidedReadwriteSplittingRuleConfiguration ruleConfig, Collection<ShardingSphereRule> builtRules) {
        this.configuration = ruleConfig;
        this.loadBalancers.putAll(ruleConfig.getLoadBalanceAlgorithms());
        this.dataSourceRules = new HashMap<String, ReadwriteSplittingDataSourceRule>(ruleConfig.getDataSources().size(), 1.0f);
        for (ReadwriteSplittingDataSourceRuleConfiguration each : ruleConfig.getDataSources()) {
            this.dataSourceRules.putAll(this.createReadwriteSplittingDataSourceRules(each, builtRules));
        }
    }

    private Map<String, ReadwriteSplittingDataSourceRule> createReadwriteSplittingDataSourceRules(ReadwriteSplittingDataSourceRuleConfiguration config, Collection<ShardingSphereRule> builtRules) {
        ReadQueryLoadBalanceAlgorithm loadBalanceAlgorithm = this.loadBalancers.getOrDefault(config.getLoadBalancerName(), ReadQueryLoadBalanceAlgorithmFactory.newInstance());
        return null == config.getStaticStrategy() ? this.createDynamicReadwriteSplittingDataSourceRules(config, builtRules, loadBalanceAlgorithm) : this.createStaticReadwriteSplittingDataSourceRules(config, builtRules, loadBalanceAlgorithm);
    }

    private Map<String, ReadwriteSplittingDataSourceRule> createStaticReadwriteSplittingDataSourceRules(ReadwriteSplittingDataSourceRuleConfiguration config, Collection<ShardingSphereRule> builtRules, ReadQueryLoadBalanceAlgorithm loadBalanceAlgorithm) {
        LinkedHashMap<String, ReadwriteSplittingDataSourceRule> result = new LinkedHashMap<String, ReadwriteSplittingDataSourceRule>();
        List inlineReadwriteDataSourceNames = new InlineExpressionParser(config.getName()).splitAndEvaluate();
        List inlineWriteDatasourceNames = new InlineExpressionParser(config.getStaticStrategy().getWriteDataSourceName()).splitAndEvaluate();
        List<List<String>> inlineReadDatasourceNames = config.getStaticStrategy().getReadDataSourceNames().stream().map(each -> new InlineExpressionParser(each).splitAndEvaluate()).collect(Collectors.toList());
        Preconditions.checkArgument((inlineWriteDatasourceNames.size() == inlineReadwriteDataSourceNames.size() ? 1 : 0) != 0, (Object)"Inline expression write data source names size error");
        inlineReadDatasourceNames.forEach(each -> Preconditions.checkArgument((each.size() == inlineReadwriteDataSourceNames.size() ? 1 : 0) != 0, (Object)"Inline expression read data source names size error"));
        for (int i = 0; i < inlineReadwriteDataSourceNames.size(); ++i) {
            ReadwriteSplittingDataSourceRuleConfiguration staticConfig = this.createStaticDataSourceRuleConfiguration(config, i, inlineReadwriteDataSourceNames, inlineWriteDatasourceNames, inlineReadDatasourceNames);
            result.put((String)inlineReadwriteDataSourceNames.get(i), new ReadwriteSplittingDataSourceRule(staticConfig, loadBalanceAlgorithm, builtRules));
        }
        return result;
    }

    private ReadwriteSplittingDataSourceRuleConfiguration createStaticDataSourceRuleConfiguration(ReadwriteSplittingDataSourceRuleConfiguration config, int index, List<String> readwriteDataSourceNames, List<String> writeDatasourceNames, List<List<String>> readDatasourceNames) {
        List readDataSourceNames = readDatasourceNames.stream().map(each -> (String)each.get(index)).collect(Collectors.toList());
        return new ReadwriteSplittingDataSourceRuleConfiguration(readwriteDataSourceNames.get(index), new StaticReadwriteSplittingStrategyConfiguration(writeDatasourceNames.get(index), readDataSourceNames), null, config.getLoadBalancerName());
    }

    private Map<String, ReadwriteSplittingDataSourceRule> createDynamicReadwriteSplittingDataSourceRules(ReadwriteSplittingDataSourceRuleConfiguration config, Collection<ShardingSphereRule> builtRules, ReadQueryLoadBalanceAlgorithm loadBalanceAlgorithm) {
        LinkedHashMap<String, ReadwriteSplittingDataSourceRule> result = new LinkedHashMap<String, ReadwriteSplittingDataSourceRule>();
        List inlineReadwriteDataSourceNames = new InlineExpressionParser(config.getName()).splitAndEvaluate();
        List inlineAutoAwareDataSourceNames = new InlineExpressionParser(config.getDynamicStrategy().getAutoAwareDataSourceName()).splitAndEvaluate();
        Preconditions.checkArgument((inlineAutoAwareDataSourceNames.size() == inlineReadwriteDataSourceNames.size() ? 1 : 0) != 0, (Object)"Inline expression auto aware data source names size error");
        for (int i = 0; i < inlineReadwriteDataSourceNames.size(); ++i) {
            ReadwriteSplittingDataSourceRuleConfiguration dynamicConfig = this.createDynamicDataSourceRuleConfiguration(config, i, inlineReadwriteDataSourceNames, inlineAutoAwareDataSourceNames);
            result.put((String)inlineReadwriteDataSourceNames.get(i), new ReadwriteSplittingDataSourceRule(dynamicConfig, loadBalanceAlgorithm, builtRules));
        }
        return result;
    }

    private ReadwriteSplittingDataSourceRuleConfiguration createDynamicDataSourceRuleConfiguration(ReadwriteSplittingDataSourceRuleConfiguration config, int index, List<String> readwriteDataSourceNames, List<String> autoAwareDataSourceNames) {
        return new ReadwriteSplittingDataSourceRuleConfiguration(readwriteDataSourceNames.get(index), null, new DynamicReadwriteSplittingStrategyConfiguration(autoAwareDataSourceNames.get(index), config.getDynamicStrategy().getWriteDataSourceQueryEnabled()), config.getLoadBalancerName());
    }

    public ReadwriteSplittingDataSourceRule getSingleDataSourceRule() {
        return this.dataSourceRules.values().iterator().next();
    }

    public Optional<ReadwriteSplittingDataSourceRule> findDataSourceRule(String dataSourceName) {
        return Optional.ofNullable(this.dataSourceRules.get(dataSourceName));
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, ReadwriteSplittingDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            result.put(entry.getValue().getName(), entry.getValue().getReadwriteSplittingStrategy().getAllDataSources());
        }
        return result;
    }

    public void updateStatus(DataSourceStatusChangedEvent event) {
        StorageNodeDataSourceChangedEvent dataSourceEvent = (StorageNodeDataSourceChangedEvent)event;
        QualifiedDatabase qualifiedDatabase = dataSourceEvent.getQualifiedDatabase();
        ReadwriteSplittingDataSourceRule dataSourceRule = this.dataSourceRules.get(qualifiedDatabase.getGroupName());
        Preconditions.checkNotNull((Object)dataSourceRule, (String)"Can not find readwrite-splitting data source rule in database `%s`", (Object)qualifiedDatabase.getDatabaseName());
        dataSourceRule.updateDisabledDataSourceNames(dataSourceEvent.getQualifiedDatabase().getDataSourceName(), StorageNodeStatus.isDisable((String)dataSourceEvent.getDataSource().getStatus()));
    }

    public Map<String, Object> getExportData() {
        HashMap<String, Object> result = new HashMap<String, Object>(2, 1.0f);
        result.put("dynamic_readwrite_splitting_rules", this.exportDynamicDataSources());
        result.put("static_readwrite_splitting_rules", this.exportStaticDataSources());
        return result;
    }

    private Map<String, Map<String, String>> exportDynamicDataSources() {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>(this.dataSourceRules.size(), 1.0f);
        for (ReadwriteSplittingDataSourceRule each : this.dataSourceRules.values()) {
            if (!(each.getReadwriteSplittingStrategy() instanceof DynamicReadwriteSplittingStrategy)) continue;
            LinkedHashMap<String, String> exportedDataSources = new LinkedHashMap<String, String>(2, 1.0f);
            exportedDataSources.put("auto_aware_data_source_name", ((DynamicReadwriteSplittingStrategy)each.getReadwriteSplittingStrategy()).getAutoAwareDataSourceName());
            exportedDataSources.put("primary_data_source_name", each.getWriteDataSource());
            exportedDataSources.put("replica_data_source_names", String.join((CharSequence)",", each.getReadwriteSplittingStrategy().getReadDataSources()));
            result.put(each.getName(), exportedDataSources);
        }
        return result;
    }

    private Map<String, Map<String, String>> exportStaticDataSources() {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>(this.dataSourceRules.size(), 1.0f);
        for (ReadwriteSplittingDataSourceRule each : this.dataSourceRules.values()) {
            if (!(each.getReadwriteSplittingStrategy() instanceof StaticReadwriteSplittingStrategy)) continue;
            LinkedHashMap<String, String> exportedDataSources = new LinkedHashMap<String, String>(2, 1.0f);
            exportedDataSources.put("primary_data_source_name", each.getWriteDataSource());
            exportedDataSources.put("replica_data_source_names", String.join((CharSequence)",", each.getReadwriteSplittingStrategy().getReadDataSources()));
            result.put(each.getName(), exportedDataSources);
        }
        return result;
    }

    public String getType() {
        return ReadwriteSplittingRule.class.getSimpleName();
    }

    @Generated
    public RuleConfiguration getConfiguration() {
        return this.configuration;
    }
}

