/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.schedule.core.context;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;
import org.apache.shardingsphere.infra.schedule.CronJob;
import org.apache.shardingsphere.infra.schedule.ScheduleContext;
import org.apache.shardingsphere.schedule.core.model.JobParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterScheduleContext
implements ScheduleContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterScheduleContext.class);
    private static final Map<String, ScheduleJobBootstrap> SCHEDULE_JOB_BOOTSTRAP_MAP = new HashMap<String, ScheduleJobBootstrap>();
    private final String serverList;
    private final String namespace;
    private final LazyInitializer<CoordinatorRegistryCenter> registryCenterLazyInitializer = new LazyInitializer<CoordinatorRegistryCenter>(){

        protected CoordinatorRegistryCenter initialize() {
            return ClusterScheduleContext.this.initRegisterCenter();
        }
    };

    public void startSchedule(CronJob job) {
        CoordinatorRegistryCenter registryCenter = this.getRegistryCenter();
        Preconditions.checkNotNull((Object)registryCenter, (Object)"Coordinator registry center failed to initialize.");
        if (null != SCHEDULE_JOB_BOOTSTRAP_MAP.get(job.getJobName())) {
            SCHEDULE_JOB_BOOTSTRAP_MAP.get(job.getJobName()).shutdown();
        }
        JobConfiguration jobConfig = JobConfiguration.newBuilder((String)job.getJobName(), (int)1).cron(job.getCron()).overwrite(true).build();
        ScheduleJobBootstrap bootstrap = new ScheduleJobBootstrap(registryCenter, (ElasticJob)new ConsumerSimpleJob(job.getJob()), jobConfig);
        SCHEDULE_JOB_BOOTSTRAP_MAP.put(job.getJobName(), bootstrap);
        SCHEDULE_JOB_BOOTSTRAP_MAP.get(job.getJobName()).schedule();
    }

    public void closeSchedule(String jobName) {
        Optional.ofNullable(SCHEDULE_JOB_BOOTSTRAP_MAP.remove(jobName)).ifPresent(ScheduleJobBootstrap::shutdown);
    }

    private CoordinatorRegistryCenter getRegistryCenter() {
        return (CoordinatorRegistryCenter)this.registryCenterLazyInitializer.get();
    }

    private CoordinatorRegistryCenter initRegisterCenter() {
        ZookeeperRegistryCenter result = new ZookeeperRegistryCenter(new ZookeeperConfiguration(this.serverList, this.namespace));
        result.init();
        return result;
    }

    @Generated
    public ClusterScheduleContext(String serverList, String namespace) {
        this.serverList = serverList;
        this.namespace = namespace;
    }

    private static final class ConsumerSimpleJob
    implements SimpleJob {
        private final Consumer<JobParameter> job;

        public void execute(ShardingContext shardingContext) {
            this.job.accept(new JobParameter());
        }

        @Generated
        public ConsumerSimpleJob(Consumer<JobParameter> job) {
            this.job = job;
        }
    }
}

