/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.column;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.shadow.algorithm.shadow.validator.ShadowValueValidator;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.column.PreciseColumnShadowValue;

public abstract class AbstractColumnMatchedShadowAlgorithm
implements ColumnShadowAlgorithm<Comparable<?>> {
    private static final String COLUMN_PROPS_KEY = "column";
    private static final String OPERATION_PROPS_KEY = "operation";
    private Properties props;
    private String shadowColumn;
    private ShadowOperationType shadowOperationType;

    public void init(Properties props) {
        this.props = props;
        this.shadowColumn = this.getShadowColumn(props);
        this.shadowOperationType = this.getShadowOperationType(props);
    }

    private String getShadowColumn(Properties props) {
        String result = props.getProperty(COLUMN_PROPS_KEY);
        Preconditions.checkNotNull((Object)result, (Object)"Column shadow algorithm column cannot be null.");
        return result;
    }

    private ShadowOperationType getShadowOperationType(Properties props) {
        String operationType = props.getProperty(OPERATION_PROPS_KEY);
        Preconditions.checkNotNull((Object)operationType, (Object)"Column shadow algorithm operation cannot be null.");
        Optional result = ShadowOperationType.contains((String)operationType);
        Preconditions.checkState((boolean)result.isPresent(), (Object)"Column shadow algorithm operation must be one of [select, insert, update, delete].");
        return (ShadowOperationType)result.get();
    }

    public final boolean isShadow(PreciseColumnShadowValue<Comparable<?>> shadowValue) {
        String table = shadowValue.getLogicTableName();
        String column = shadowValue.getColumnName();
        Comparable value = shadowValue.getValue();
        if (this.shadowOperationType == shadowValue.getShadowOperationType() && this.shadowColumn.equals(column)) {
            ShadowValueValidator.validate(table, column, value);
            return this.matchesShadowValue(value);
        }
        return false;
    }

    protected abstract boolean matchesShadowValue(Comparable<?> var1);

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

