/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.column;

import com.google.common.base.Preconditions;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.shardingsphere.shadow.algorithm.shadow.column.AbstractColumnMatchedShadowAlgorithm;

public final class ColumnRegexMatchedShadowAlgorithm
extends AbstractColumnMatchedShadowAlgorithm {
    private static final String REGEX_PROPS_KEY = "regex";
    private Pattern regex;

    @Override
    public void init(Properties props) {
        super.init(props);
        this.regex = this.getRegex(props);
    }

    private Pattern getRegex(Properties props) {
        String regex = props.getProperty(REGEX_PROPS_KEY);
        Preconditions.checkNotNull((Object)regex, (Object)"Column regex match shadow algorithm regex cannot be null.");
        return Pattern.compile(regex);
    }

    @Override
    protected boolean matchesShadowValue(Comparable<?> value) {
        return this.regex.matcher(String.valueOf(value)).matches();
    }

    public String getType() {
        return "REGEX_MATCH";
    }
}

