/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.column;

import com.google.common.base.Preconditions;
import java.util.Properties;
import org.apache.shardingsphere.shadow.algorithm.shadow.column.AbstractColumnMatchedShadowAlgorithm;

public final class ColumnValueMatchedShadowAlgorithm
extends AbstractColumnMatchedShadowAlgorithm {
    private static final String VALUE_PROPS_KEY = "value";
    private String shadowValue;

    @Override
    public void init(Properties props) {
        super.init(props);
        this.shadowValue = this.getShadowValue(props);
    }

    private String getShadowValue(Properties props) {
        String result = props.getProperty(VALUE_PROPS_KEY);
        Preconditions.checkNotNull((Object)result, (Object)"Column value match shadow algorithm value cannot be null.");
        return result;
    }

    @Override
    protected boolean matchesShadowValue(Comparable<?> value) {
        return this.shadowValue.equals(String.valueOf(value));
    }

    public String getType() {
        return "VALUE_MATCH";
    }
}

