/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.hint;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.shadow.algorithm.shadow.hint.ShadowHintExtractor;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.hint.HintShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.hint.PreciseHintShadowValue;

public final class SimpleHintShadowAlgorithm
implements HintShadowAlgorithm<String> {
    private Properties props;
    private Map<String, String> simpleHint;

    public void init(Properties props) {
        this.props = props;
        this.checkPropsSize(props);
        this.simpleHint = this.initSimpleHint(props);
    }

    private Map<String, String> initSimpleHint(Properties props) {
        HashMap<String, String> result = new HashMap<String, String>(props.size(), 1.0f);
        Set<String> strings = props.stringPropertyNames();
        for (String each : strings) {
            result.put(each, props.getProperty(each));
        }
        return result;
    }

    private void checkPropsSize(Properties props) {
        Preconditions.checkState((!props.isEmpty() ? 1 : 0) != 0, (Object)"Simple hint shadow algorithm props cannot be empty.");
    }

    public boolean isShadow(Collection<String> shadowTableNames, PreciseHintShadowValue<String> noteShadowValue) {
        if (ShadowOperationType.HINT_MATCH != noteShadowValue.getShadowOperationType() && !shadowTableNames.contains(noteShadowValue.getLogicTableName())) {
            return false;
        }
        return ShadowHintExtractor.extractSimpleHint((String)((Object)noteShadowValue.getValue())).filter(this::containsHint).isPresent();
    }

    private boolean containsHint(Map<String, String> preciseHint) {
        for (Map.Entry<String, String> entry : this.simpleHint.entrySet()) {
            if (entry.getValue().equals(preciseHint.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public String getType() {
        return "SIMPLE_HINT";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

