/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.algorithm.shadow.validator;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.shadow.exception.data.UnsupportedShadowColumnTypeException;

public final class ShadowValueValidator {
    private static final Set<Class<?>> UNSUPPORTED_TYPES = new HashSet();

    public static void validate(String table, String column, Comparable<?> shadowValue) {
        for (Class<?> each : UNSUPPORTED_TYPES) {
            if (!each.isAssignableFrom(shadowValue.getClass())) continue;
            throw new UnsupportedShadowColumnTypeException(table, column, each);
        }
    }

    @Generated
    private ShadowValueValidator() {
    }

    static {
        UNSUPPORTED_TYPES.add(Date.class);
        UNSUPPORTED_TYPES.add(Enum.class);
    }
}

