/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.checker;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.api.shadow.hint.HintShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

public abstract class AbstractShadowRuleConfigurationChecker<T extends RuleConfiguration>
implements RuleConfigurationChecker<T> {
    public final void check(String databaseName, T config, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules) {
        this.checkShadowRuleConfiguration(config, dataSourceMap);
    }

    protected abstract void checkShadowRuleConfiguration(T var1, Map<String, DataSource> var2);

    protected void checkDataSources(Map<String, ShadowDataSourceConfiguration> shadowDataSources, Map<String, DataSource> dataSourceMap) {
        Set<String> dataSource = dataSourceMap.keySet();
        for (Map.Entry<String, ShadowDataSourceConfiguration> entry : shadowDataSources.entrySet()) {
            ShadowDataSourceConfiguration shadowConfiguration = entry.getValue();
            boolean shadowDataSourceState = dataSource.contains(shadowConfiguration.getProductionDataSourceName()) && dataSource.contains(shadowConfiguration.getShadowDataSourceName());
            Preconditions.checkState((boolean)shadowDataSourceState, (Object)"No available data source for shadow data source mapping configuration");
        }
    }

    protected void shadowTableDataSourcesAutoReferences(Map<String, ShadowTableConfiguration> shadowTables, Map<String, ShadowDataSourceConfiguration> dataSources) {
        if (1 == dataSources.size()) {
            String dataSourceName = dataSources.keySet().iterator().next();
            shadowTables.values().stream().map(ShadowTableConfiguration::getDataSourceNames).filter(Collection::isEmpty).forEach(dataSourceNames -> dataSourceNames.add(dataSourceName));
        }
    }

    protected void shadowTableDataSourcesReferencesCheck(Map<String, ShadowTableConfiguration> shadowTables, Map<String, ShadowDataSourceConfiguration> dataSources) {
        Set<String> dataSourceNames = dataSources.keySet();
        shadowTables.forEach((key, value) -> {
            for (String each : value.getDataSourceNames()) {
                Preconditions.checkState((boolean)dataSourceNames.contains(each), (String)"No available shadow data sources mappings in shadow table `%s`.", (Object)key);
            }
        });
    }

    protected void defaultShadowAlgorithmConfigurationCheck(String defaultShadowAlgorithmName, Map<String, AlgorithmConfiguration> shadowAlgorithmConfigs) {
        if (null != defaultShadowAlgorithmName) {
            AlgorithmConfiguration algorithmConfig = shadowAlgorithmConfigs.get(defaultShadowAlgorithmName);
            boolean state = null != algorithmConfig && "SIMPLE_HINT".equals(algorithmConfig.getType());
            Preconditions.checkState((boolean)state, (Object)"Default shadow algorithm class should be implement HintShadowAlgorithm.");
        }
    }

    protected void defaultShadowAlgorithmCheck(String defaultShadowAlgorithmName, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        if (null != defaultShadowAlgorithmName) {
            boolean isHintShadowAlgorithmState = shadowAlgorithms.get(defaultShadowAlgorithmName) instanceof HintShadowAlgorithm;
            Preconditions.checkState((boolean)isHintShadowAlgorithmState, (Object)"Default shadow algorithm class should be implement HintShadowAlgorithm.");
        }
    }

    protected void shadowTableAlgorithmsAutoReferences(Map<String, ShadowTableConfiguration> shadowTables, Set<String> shadowAlgorithmNames, String defaultShadowAlgorithmName) {
        for (Map.Entry<String, ShadowTableConfiguration> entry : shadowTables.entrySet()) {
            Collection names = entry.getValue().getShadowAlgorithmNames();
            names.removeIf(next -> !shadowAlgorithmNames.contains(next));
            if (null == defaultShadowAlgorithmName || !names.isEmpty()) continue;
            names.add(defaultShadowAlgorithmName);
        }
    }

    protected void shadowTableAlgorithmsReferencesCheck(Map<String, ShadowTableConfiguration> shadowTables) {
        shadowTables.forEach((key, value) -> Preconditions.checkState((!value.getShadowAlgorithmNames().isEmpty() ? 1 : 0) != 0, (String)"No available shadow Algorithm configuration in shadow table `%s`.", (Object)key));
    }
}

