/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.checker;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.shadow.algorithm.config.AlgorithmProvidedShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.checker.AbstractShadowRuleConfigurationChecker;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

public final class AlgorithmProvidedShadowRuleConfigurationChecker
extends AbstractShadowRuleConfigurationChecker<AlgorithmProvidedShadowRuleConfiguration> {
    @Override
    protected void checkShadowRuleConfiguration(AlgorithmProvidedShadowRuleConfiguration config, Map<String, DataSource> dataSourceMap) {
        Map<String, ShadowDataSourceConfiguration> dataSources = config.getDataSources();
        this.checkDataSources(dataSources, dataSourceMap);
        Map<String, ShadowTableConfiguration> shadowTables = config.getTables();
        this.shadowTableDataSourcesAutoReferences(shadowTables, dataSources);
        this.shadowTableDataSourcesReferencesCheck(shadowTables, dataSources);
        Map<String, ShadowAlgorithm> shadowAlgorithms = config.getShadowAlgorithms();
        String defaultShadowAlgorithmName = config.getDefaultShadowAlgorithmName();
        this.defaultShadowAlgorithmCheck(defaultShadowAlgorithmName, shadowAlgorithms);
        this.shadowTableAlgorithmsAutoReferences(shadowTables, shadowAlgorithms.keySet(), defaultShadowAlgorithmName);
        this.shadowTableAlgorithmsReferencesCheck(shadowTables);
    }

    public int getOrder() {
        return 51;
    }

    public Class<AlgorithmProvidedShadowRuleConfiguration> getTypeClass() {
        return AlgorithmProvidedShadowRuleConfiguration.class;
    }
}

