/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.checker;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.checker.AbstractShadowRuleConfigurationChecker;

public final class ShadowRuleConfigurationChecker
extends AbstractShadowRuleConfigurationChecker<ShadowRuleConfiguration> {
    @Override
    protected void checkShadowRuleConfiguration(ShadowRuleConfiguration config, Map<String, DataSource> dataSourceMap) {
        Map dataSources = config.getDataSources();
        this.checkDataSources(dataSources, dataSourceMap);
        Map shadowTables = config.getTables();
        this.shadowTableDataSourcesAutoReferences(shadowTables, dataSources);
        this.shadowTableDataSourcesReferencesCheck(shadowTables, dataSources);
        Map shadowAlgorithmConfigs = config.getShadowAlgorithms();
        String defaultShadowAlgorithmName = config.getDefaultShadowAlgorithmName();
        this.defaultShadowAlgorithmConfigurationCheck(defaultShadowAlgorithmName, shadowAlgorithmConfigs);
        this.shadowTableAlgorithmsAutoReferences(shadowTables, shadowAlgorithmConfigs.keySet(), defaultShadowAlgorithmName);
        this.shadowTableAlgorithmsReferencesCheck(shadowTables);
    }

    public int getOrder() {
        return 50;
    }

    public Class<ShadowRuleConfiguration> getTypeClass() {
        return ShadowRuleConfiguration.class;
    }
}

